/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.util;

import java.net.URL;
import org.kie.api.KieServices;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.io.KieResources;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.DecisionTableInputType;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.switchyard.common.io.resource.ResourceDetail;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ManifestModel;
import org.switchyard.config.model.resource.ResourcesModel;

public final class Resources {
    public static void installTypes(ClassLoader loader) {
        org.switchyard.common.io.resource.ResourceType.install((ClassLoader)loader);
    }

    public static void addResources(KnowledgeComponentImplementationModel model, ClassLoader loader, KieFileSystem fileSystem) {
        ResourcesModel resourcesModel;
        ManifestModel manifestModel = model.getManifest();
        if (manifestModel != null && (resourcesModel = manifestModel.getResources()) != null) {
            KieResources kieResources = KieServices.Factory.get().getResources();
            for (org.switchyard.common.io.resource.Resource syResource : resourcesModel.getResources()) {
                Resource kieResource;
                URL locationURL = syResource.getLocationURL(loader);
                if (locationURL == null || (kieResource = kieResources.newUrlResource(locationURL)) == null) continue;
                ResourceType kieResourceType = Resources.convertResourceType(syResource.getType());
                if (kieResourceType != null) {
                    kieResource.setResourceType(kieResourceType);
                    ResourceDetail syResourceDetail = syResource.getDetail();
                    if (syResourceDetail != null) {
                        DecisionTableConfiguration kieResourceConfiguration = null;
                        if (ResourceType.DTABLE.equals((Object)kieResourceType)) {
                            String inputType = Resources.getInputType(syResourceDetail, DecisionTableInputType.XLS.toString());
                            DecisionTableConfiguration dtc = KnowledgeBuilderFactory.newDecisionTableConfiguration();
                            dtc.setInputType(DecisionTableInputType.valueOf((String)inputType));
                            dtc.setWorksheetName(Resources.getWorksheetName(syResourceDetail));
                            kieResourceConfiguration = dtc;
                        }
                        if (kieResourceConfiguration != null) {
                            kieResource.setConfiguration(kieResourceConfiguration);
                        }
                    }
                }
                fileSystem.write(kieResource);
            }
        }
    }

    private static String getInputType(ResourceDetail syResourceDetail, String defaultInputType) {
        String inputType = Strings.trimToNull((String)syResourceDetail.getInputType());
        inputType = inputType != null ? inputType.toUpperCase() : defaultInputType;
        return inputType;
    }

    private static String getWorksheetName(ResourceDetail syResourceDetail) {
        String worksheetName = syResourceDetail.getWorksheetName();
        if (worksheetName == null) {
            worksheetName = "";
        }
        return worksheetName;
    }

    public static ResourceType convertResourceType(org.switchyard.common.io.resource.ResourceType syResourceType) {
        if (syResourceType != null) {
            String resourceTypeName = syResourceType.getName();
            if ("BPMN".equals(resourceTypeName)) {
                resourceTypeName = ResourceType.BPMN2.getName();
            } else if ("XLS".equals(resourceTypeName) || "CSV".equals(resourceTypeName)) {
                resourceTypeName = ResourceType.DTABLE.getName();
            }
            return ResourceType.getResourceType((String)resourceTypeName);
        }
        return null;
    }

    private Resources() {
    }
}

