/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.service;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.switchyard.HandlerException;
import org.switchyard.component.common.knowledge.CommonKnowledgeLogger;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;

public class SwitchYardServiceResponse {
    private final Object _content;
    private final Map<String, Object> _context = new HashMap<String, Object>();
    private final Object _fault;

    SwitchYardServiceResponse(Object content, Map<String, Object> context, Object fault) {
        this._content = content;
        if (context != null) {
            this._context.putAll(context);
        }
        this._fault = fault;
    }

    public Object getContent() {
        return this._content;
    }

    public Map<String, Object> getContext() {
        return this._context;
    }

    public boolean hasFault() {
        return this.getFault(false) != null;
    }

    public Object getFault() {
        return this.getFault(true);
    }

    public Object getFault(boolean unwrap) {
        return unwrap ? this.unwrapFault(this._fault) : this._fault;
    }

    private Object unwrapFault(Object fault) {
        Throwable cause;
        if (fault instanceof HandlerException && (cause = ((HandlerException)fault).getCause()) != null) {
            return this.unwrapFault(cause);
        }
        if (fault instanceof InvocationTargetException && (cause = ((InvocationTargetException)fault).getCause()) != null) {
            return this.unwrapFault(cause);
        }
        return fault;
    }

    public String getFaultMessage() {
        String fmsg = null;
        Object fault = this.getFault();
        if (fault != null) {
            fmsg = fault instanceof Throwable ? String.format(CommonKnowledgeMessages.MESSAGES.faultEncountered() + " [%s(message=%s)]: %s", fault.getClass().getName(), ((Throwable)fault).getMessage(), fault) : String.format(CommonKnowledgeMessages.MESSAGES.faultEncountered() + " [%s]: %s", fault.getClass().getName(), fault);
        }
        return fmsg;
    }

    public void logFaultMessage() {
        this.logFaultMessage(this.getFaultMessage());
    }

    public void logFaultMessage(String fmsg) {
        if (fmsg != null) {
            CommonKnowledgeLogger.ROOT_LOGGER.formattedFaultMessage(fmsg);
        }
    }
}

