/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.runtime.KieRuntime;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.common.knowledge.CommonKnowledgeLogger;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.ListenerModel;
import org.switchyard.component.common.knowledge.config.model.ListenersModel;

public class ListenerBuilder
extends KnowledgeBuilder {
    private static final Class<?>[][] PARMAMETER_TYPES = new Class[][]{{KieRuntimeEventManager.class}, {KieRuntime.class}, new Class[0]};
    private Class<? extends EventListener> _listenerClass;
    private boolean _automaticRegistration;

    public ListenerBuilder(ClassLoader classLoader, ListenerModel listenerModel) {
        super(classLoader);
        if (listenerModel != null) {
            this._listenerClass = listenerModel.getClazz(this.getClassLoader());
            if (this._listenerClass == null) {
                throw CommonKnowledgeMessages.MESSAGES.couldNotLoadListenerClass(listenerModel.getModelConfiguration().getAttribute("class"));
            }
        }
    }

    public boolean wasAutomaticRegistration() {
        return this._automaticRegistration;
    }

    public EventListener build(KieRuntimeEventManager runtimeEventManager) {
        return this.construct(runtimeEventManager);
    }

    private EventListener construct(KieRuntimeEventManager runtimeEventManager) {
        EventListener listener = null;
        if (this._listenerClass != null) {
            Constructor<? extends EventListener> constructor = null;
            for (Class<?>[] parameterTypes : PARMAMETER_TYPES) {
                try {
                    constructor = this._listenerClass.getConstructor(parameterTypes);
                    if (constructor == null) continue;
                    break;
                }
                catch (Throwable t) {
                    t.getMessage();
                }
            }
            Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
            try {
                if (parameterTypes.length == 0) {
                    listener = (EventListener)Construction.construct(this._listenerClass);
                    this._automaticRegistration = false;
                } else if (parameterTypes.length == 1) {
                    listener = (EventListener)Construction.construct(this._listenerClass, (Class[])parameterTypes, (Object[])new Object[]{runtimeEventManager});
                    if (listener == null) {
                        CommonKnowledgeLogger.ROOT_LOGGER.attemptToRegisterListenerReturnedNull();
                    }
                    this._automaticRegistration = true;
                }
            }
            catch (Throwable t) {
                throw CommonKnowledgeMessages.MESSAGES.couldNotInstantiateListenerClass(this._listenerClass.getName());
            }
        }
        return listener;
    }

    public static List<ListenerBuilder> builders(ClassLoader classLoader, KnowledgeComponentImplementationModel implementationModel) {
        ListenersModel listenersModel;
        ArrayList<ListenerBuilder> builders = new ArrayList<ListenerBuilder>();
        if (implementationModel != null && (listenersModel = implementationModel.getListeners()) != null) {
            for (ListenerModel listenerModel : listenersModel.getListeners()) {
                if (listenerModel == null) continue;
                builders.add(new ListenerBuilder(classLoader, listenerModel));
            }
        }
        return builders;
    }
}

