/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.config.builder;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jbpm.services.task.wih.AbstractHTWorkItemHandler;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.WorkItemHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.common.type.reflect.MethodAccess;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.config.builder.KnowledgeBuilder;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.WorkItemHandlerModel;
import org.switchyard.component.common.knowledge.config.model.WorkItemHandlersModel;
import org.switchyard.component.common.knowledge.service.StandardSwitchYardServiceTaskHandler;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceInvoker;
import org.switchyard.component.common.knowledge.service.SwitchYardServiceTaskHandler;
import org.switchyard.config.model.composite.ComponentModel;

public class WorkItemHandlerBuilder
extends KnowledgeBuilder {
    private static final String HUMAN_TASK = "Human Task";
    private static final Class<?>[][] PARAMETER_TYPES = new Class[][]{{ProcessRuntime.class}, {KieRuntime.class}, new Class[0]};
    private static final Map<String, Class<? extends WorkItemHandler>> DEFAULT_HANDLERS = new HashMap<String, Class<? extends WorkItemHandler>>();
    private Class<? extends WorkItemHandler> _workItemHandlerClass;
    private String _workItemHandlerName;
    private QName _componentName;
    private String _targetNamespace;

    public WorkItemHandlerBuilder(ClassLoader classLoader, ServiceDomain serviceDomain, WorkItemHandlerModel workItemHandlerModel) {
        super(classLoader, serviceDomain);
        if (workItemHandlerModel != null) {
            WorkItemHandlersModel workItemHandlersModel = (WorkItemHandlersModel)workItemHandlerModel.getModelParent();
            KnowledgeComponentImplementationModel implementationModel = (KnowledgeComponentImplementationModel)workItemHandlersModel.getModelParent();
            ComponentModel componentModel = implementationModel.getComponent();
            this._componentName = componentModel.getQName();
            this._targetNamespace = componentModel.getTargetNamespace();
            this._workItemHandlerClass = workItemHandlerModel.getClazz(this.getClassLoader());
            if (this._workItemHandlerClass == null) {
                throw CommonKnowledgeMessages.MESSAGES.couldNotLoadWorkItemHandlerClass(workItemHandlerModel.getModelConfiguration().getAttribute("class"));
            }
            this._workItemHandlerName = workItemHandlerModel.getName();
            if (this._workItemHandlerName == null) {
                if (StandardSwitchYardServiceTaskHandler.class.isAssignableFrom(this._workItemHandlerClass)) {
                    this._workItemHandlerName = "Service Task";
                } else if (SwitchYardServiceTaskHandler.class.isAssignableFrom(this._workItemHandlerClass)) {
                    this._workItemHandlerName = "SwitchYard Service Task";
                } else if (AbstractHTWorkItemHandler.class.isAssignableFrom(this._workItemHandlerClass)) {
                    this._workItemHandlerName = HUMAN_TASK;
                } else {
                    throw CommonKnowledgeMessages.MESSAGES.couldNotUseNullNameToRegisterWorkItemHandler(this._workItemHandlerClass.getName());
                }
            }
        }
    }

    private WorkItemHandlerBuilder(ClassLoader classLoader, ServiceDomain serviceDomain, KnowledgeComponentImplementationModel implementationModel, Class<? extends WorkItemHandler> workItemHandlerClass, String workItemHandlerName) {
        super(classLoader, serviceDomain);
        this._workItemHandlerClass = workItemHandlerClass;
        this._workItemHandlerName = workItemHandlerName;
        ComponentModel componentModel = implementationModel.getComponent();
        this._componentName = componentModel.getQName();
        this._targetNamespace = componentModel.getTargetNamespace();
    }

    public String getWorkItemHandlerName() {
        return this._workItemHandlerName;
    }

    public WorkItemHandler build(ProcessRuntime processRuntime, RuntimeManager runtimeManager) {
        WorkItemHandler workItemHandler = this.construct(processRuntime, runtimeManager);
        if (workItemHandler instanceof SwitchYardServiceTaskHandler) {
            SwitchYardServiceTaskHandler systh = (SwitchYardServiceTaskHandler)workItemHandler;
            systh.setComponentName(this._componentName);
            systh.setInvoker(new SwitchYardServiceInvoker(this.getServiceDomain(), this._targetNamespace));
            systh.setProcessRuntime(processRuntime);
        }
        return workItemHandler;
    }

    private WorkItemHandler construct(ProcessRuntime processRuntime, RuntimeManager runtimeManager) {
        WorkItemHandler handler = null;
        if (this._workItemHandlerClass != null) {
            MethodAccess access;
            Constructor<? extends WorkItemHandler> constructor = null;
            for (Class<?>[] parameterTypes : PARAMETER_TYPES) {
                try {
                    constructor = this._workItemHandlerClass.getConstructor(parameterTypes);
                    if (constructor == null) continue;
                    break;
                }
                catch (Throwable t) {
                    t.getMessage();
                }
            }
            Class[] parameterTypes = constructor != null ? constructor.getParameterTypes() : new Class[]{};
            try {
                if (parameterTypes.length == 0) {
                    handler = (WorkItemHandler)Construction.construct(this._workItemHandlerClass);
                } else if (parameterTypes.length == 1) {
                    handler = (WorkItemHandler)Construction.construct(this._workItemHandlerClass, (Class[])parameterTypes, (Object[])new Object[]{processRuntime});
                }
            }
            catch (Throwable t) {
                throw CommonKnowledgeMessages.MESSAGES.couldNotInstantiateWorkItemHandlerClass(this._workItemHandlerClass.getName());
            }
            if (handler != null && runtimeManager != null && (access = new MethodAccess(handler.getClass(), "getRuntimeManager", "setRuntimeManager")).isWriteable()) {
                access.write((Object)handler, (Object)runtimeManager);
            }
        }
        return handler;
    }

    public static List<WorkItemHandlerBuilder> builders(ClassLoader classLoader, ServiceDomain serviceDomain, KnowledgeComponentImplementationModel implementationModel) {
        ArrayList<WorkItemHandlerBuilder> builders = new ArrayList<WorkItemHandlerBuilder>();
        HashSet<String> registeredNames = new HashSet<String>();
        if (implementationModel != null) {
            WorkItemHandlersModel workItemHandlersModel = implementationModel.getWorkItemHandlers();
            if (workItemHandlersModel != null) {
                for (WorkItemHandlerModel workItemHandlerModel : workItemHandlersModel.getWorkItemHandlers()) {
                    if (workItemHandlerModel == null) continue;
                    WorkItemHandlerBuilder builder = new WorkItemHandlerBuilder(classLoader, serviceDomain, workItemHandlerModel);
                    builders.add(builder);
                    String name = builder.getWorkItemHandlerName();
                    if (name == null) continue;
                    registeredNames.add(name);
                }
            }
            for (Map.Entry entry : DEFAULT_HANDLERS.entrySet()) {
                String name = (String)entry.getKey();
                if (registeredNames.contains(name)) continue;
                WorkItemHandlerBuilder builder = new WorkItemHandlerBuilder(classLoader, serviceDomain, implementationModel, (Class)entry.getValue(), name);
                builders.add(builder);
                registeredNames.add(name);
            }
        }
        return builders;
    }

    static {
        DEFAULT_HANDLERS.put("SwitchYard Service Task", SwitchYardServiceTaskHandler.class);
        DEFAULT_HANDLERS.put("Service Task", StandardSwitchYardServiceTaskHandler.class);
    }
}

