/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.exchange;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.kie.api.runtime.Globals;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperation;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperations;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeEngine;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManager;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManagerFactory;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeManagerType;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.ServiceHandler;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceOperation;

public abstract class KnowledgeExchangeHandler
extends BaseServiceHandler
implements ServiceHandler {
    private final KnowledgeComponentImplementationModel _model;
    private final ServiceDomain _serviceDomain;
    private final QName _serviceName;
    private final Map<String, KnowledgeOperation> _operations = new HashMap<String, KnowledgeOperation>();
    private ClassLoader _loader;
    private KnowledgeRuntimeManagerFactory _runtimeManagerFactory;

    public KnowledgeExchangeHandler(KnowledgeComponentImplementationModel model, ServiceDomain serviceDomain, QName serviceName) {
        super(serviceDomain);
        this._model = model;
        this._serviceDomain = serviceDomain;
        this._serviceName = serviceName;
    }

    public ServiceDomain getServiceDomain() {
        return this._serviceDomain;
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    protected ClassLoader getLoader() {
        return this._loader;
    }

    protected void doStart() {
        this._loader = Classes.getClassLoader((ClassLoader[])new ClassLoader[]{this.getDeploymentClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()});
        ResourceType.install((ClassLoader)this._loader);
        KnowledgeOperations.registerOperations(this._model, this._operations, this.getDefaultOperation());
        this._runtimeManagerFactory = new KnowledgeRuntimeManagerFactory(this._loader, this._serviceDomain, this._serviceName, this._model);
    }

    protected KnowledgeRuntimeManager newSingletonRuntimeManager() {
        return this._runtimeManagerFactory.newRuntimeManager(KnowledgeRuntimeManagerType.SINGLETON);
    }

    protected KnowledgeRuntimeManager newPerRequestRuntimeManager() {
        return this._runtimeManagerFactory.newRuntimeManager(KnowledgeRuntimeManagerType.PER_REQUEST);
    }

    protected KnowledgeRuntimeManager newPerProcessInstanceRuntimeManager() {
        return this._runtimeManagerFactory.newRuntimeManager(KnowledgeRuntimeManagerType.PER_PROCESS_INSTANCE);
    }

    protected void doStop() {
        this._loader = null;
        this._operations.clear();
    }

    public abstract KnowledgeOperation getDefaultOperation();

    private KnowledgeOperation getOperation(ServiceOperation serviceOperation) {
        String operationName;
        if (serviceOperation != null && (operationName = Strings.trimToNull((String)serviceOperation.getName())) != null) {
            return this._operations.get(operationName);
        }
        return null;
    }

    public final void handleMessage(Exchange exchange) throws HandlerException {
        if (ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            ExchangeContract contract = exchange.getContract();
            KnowledgeOperation operation = this.getOperation(contract.getProviderOperation());
            if (operation == null) {
                operation = this.getOperation(contract.getConsumerOperation());
            }
            if (operation == null) {
                operation = this._operations.get("default");
            }
            this.handleOperation(exchange, operation);
        }
    }

    public abstract void handleOperation(Exchange var1, KnowledgeOperation var2) throws HandlerException;

    protected boolean isBoolean(Exchange exchange, Message message, String name) {
        Boolean b = this.getBoolean(exchange, message, name);
        return b != null && b != false;
    }

    protected Boolean getBoolean(Exchange exchange, Message message, String name) {
        Object value = this.getObject(exchange, message, name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf(((String)value).trim());
        }
        return false;
    }

    protected Integer getInteger(Exchange exchange, Message message, String name) {
        Object value = this.getObject(exchange, message, name);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf(((String)value).trim());
        }
        return null;
    }

    protected Long getLong(Exchange exchange, Message message, String name) {
        Object value = this.getObject(exchange, message, name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            return Long.valueOf(((String)value).trim());
        }
        return null;
    }

    protected String getString(Exchange exchange, Message message, String name) {
        Object value = this.getObject(exchange, message, name);
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    protected Object getObject(Exchange exchange, Message message, String name) {
        Context context = message != null ? exchange.getContext(message) : exchange.getContext();
        return context.getPropertyValue(name);
    }

    protected Map<String, Object> getGlobalVariables(KnowledgeRuntimeEngine runtimeEngine) {
        Globals globals;
        HashMap<String, Object> globalVariables = new HashMap<String, Object>();
        if (runtimeEngine != null && (globals = runtimeEngine.getSessionGlobals()) != null) {
            for (String key : globals.getGlobalKeys()) {
                Object value = globals.get(key);
                globalVariables.put(key, value);
            }
        }
        return globalVariables;
    }
}

