/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlType;
import org.kie.api.runtime.Globals;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.knowledge.CommonKnowledgeMessages;
import org.switchyard.component.common.knowledge.config.model.FaultModel;
import org.switchyard.component.common.knowledge.config.model.FaultsModel;
import org.switchyard.component.common.knowledge.config.model.GlobalModel;
import org.switchyard.component.common.knowledge.config.model.GlobalsModel;
import org.switchyard.component.common.knowledge.config.model.InputModel;
import org.switchyard.component.common.knowledge.config.model.InputsModel;
import org.switchyard.component.common.knowledge.config.model.KnowledgeComponentImplementationModel;
import org.switchyard.component.common.knowledge.config.model.OperationModel;
import org.switchyard.component.common.knowledge.config.model.OperationsModel;
import org.switchyard.component.common.knowledge.config.model.OutputModel;
import org.switchyard.component.common.knowledge.config.model.OutputsModel;
import org.switchyard.component.common.knowledge.expression.ContextMap;
import org.switchyard.component.common.knowledge.expression.Expression;
import org.switchyard.component.common.knowledge.expression.ExpressionFactory;
import org.switchyard.component.common.knowledge.expression.ExpressionMapping;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperation;
import org.switchyard.component.common.knowledge.operation.KnowledgeOperationType;
import org.switchyard.component.common.knowledge.runtime.KnowledgeRuntimeEngine;

public final class KnowledgeOperations {
    public static void registerOperations(KnowledgeComponentImplementationModel model, Map<String, KnowledgeOperation> operations, KnowledgeOperation defaultOperation) {
        OperationsModel operationsModel = model.getOperations();
        if (operationsModel != null) {
            for (OperationModel operationModel : operationsModel.getOperations()) {
                String eventId;
                KnowledgeOperationType type;
                String name = Strings.trimToNull((String)operationModel.getName());
                if (name == null) {
                    name = "default";
                }
                if ((type = operationModel.getType()) == null) {
                    type = defaultOperation.getType();
                }
                if ((eventId = operationModel.getEventId()) == null) {
                    eventId = defaultOperation.getEventId();
                }
                KnowledgeOperation operation = new KnowledgeOperation(type, eventId);
                KnowledgeOperations.mapExpressions(operationModel, operation);
                if (operations.containsKey(name)) {
                    throw CommonKnowledgeMessages.MESSAGES.cannotRegisterOperation(type.toString(), name);
                }
                operations.put(name, operation);
            }
        }
        if (!operations.containsKey("default")) {
            operations.put("default", defaultOperation);
        }
    }

    private static void mapExpressions(OperationModel operationModel, KnowledgeOperation operation) {
        FaultsModel faultsModel;
        OutputsModel outputsModel;
        InputsModel inputsModel;
        GlobalsModel globalsModel = operationModel.getGlobals();
        if (globalsModel != null) {
            for (GlobalModel globalModel : globalsModel.getGlobals()) {
                operation.getGlobalExpressionMappings().add(new ExpressionMapping(globalModel));
            }
        }
        if ((inputsModel = operationModel.getInputs()) != null) {
            for (InputModel inputModel : inputsModel.getInputs()) {
                operation.getInputExpressionMappings().add(new ExpressionMapping(inputModel));
            }
        }
        if ((outputsModel = operationModel.getOutputs()) != null) {
            for (OutputModel outputModel : outputsModel.getOutputs()) {
                operation.getOutputExpressionMappings().add(new ExpressionMapping(outputModel));
            }
        }
        if ((faultsModel = operationModel.getFaults()) != null) {
            for (FaultModel faultModel : faultsModel.getFaults()) {
                operation.getFaultExpressionMappings().add(new ExpressionMapping(faultModel));
            }
        }
    }

    public static void setGlobals(Message message, KnowledgeOperation operation, KnowledgeRuntimeEngine runtime, boolean singleton) {
        Globals globals = runtime.getSessionGlobals();
        if (globals != null) {
            HashMap<String, Object> globalsMap = new HashMap<String, Object>();
            globalsMap.put("globals", new ConcurrentHashMap());
            Map<String, Object> expressionMap = KnowledgeOperations.getMap(message, operation.getGlobalExpressionMappings(), null);
            if (expressionMap != null) {
                globalsMap.putAll(expressionMap);
            }
            for (Map.Entry globalsEntry : globalsMap.entrySet()) {
                if (!singleton) {
                    globals.set((String)globalsEntry.getKey(), globalsEntry.getValue());
                    continue;
                }
                if (globals.get((String)globalsEntry.getKey()) != null && (globalsEntry.getValue() == null || !(globalsEntry.getValue() instanceof Map) || ((Map)globalsEntry.getValue()).isEmpty())) continue;
                globals.set((String)globalsEntry.getKey(), globalsEntry.getValue());
            }
        }
    }

    public static boolean containsGlobals(Message message, KnowledgeOperation operation, KnowledgeRuntimeEngine runtime) {
        Map<String, Object> expressionMap = KnowledgeOperations.getMap(message, operation.getGlobalExpressionMappings(), null);
        return expressionMap != null && expressionMap.size() > 0;
    }

    public static Object getInput(Message message, KnowledgeOperation operation, KnowledgeRuntimeEngine runtime) {
        List<Object> list = KnowledgeOperations.getList(message, operation.getInputExpressionMappings());
        switch (list.size()) {
            case 0: {
                return KnowledgeOperations.filterRemoteDefaultInputContent(message.getContent(), runtime);
            }
            case 1: {
                return list.get(0);
            }
        }
        return list;
    }

    public static List<Object> getInputList(Message message, KnowledgeOperation operation, KnowledgeRuntimeEngine runtime) {
        return KnowledgeOperations.getInputList(message, operation.getInputExpressionMappings(), runtime);
    }

    public static List<Object> getInputOnlyList(Message message, KnowledgeOperation operation, KnowledgeRuntimeEngine runtime) {
        return KnowledgeOperations.getInputList(message, operation.getInputOnlyExpressionMappings(), runtime);
    }

    private static List<Object> getInputList(Message message, List<ExpressionMapping> inputs, KnowledgeRuntimeEngine runtime) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (inputs.size() > 0) {
            list.addAll(KnowledgeOperations.getList(message, inputs));
        } else {
            KnowledgeOperations.expand(KnowledgeOperations.filterRemoteDefaultInputContent(message.getContent(), runtime), list);
        }
        return list;
    }

    public static Map<String, Object> getInputOutputMap(Message message, KnowledgeOperation operation, KnowledgeRuntimeEngine runtime) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Map<String, ExpressionMapping> inputs = operation.getInputOutputExpressionMappings();
        for (Map.Entry<String, ExpressionMapping> entry : inputs.entrySet()) {
            Object output;
            List<Object> list = KnowledgeOperations.getList(message, Collections.singletonList(entry.getValue()));
            switch (list.size()) {
                case 0: {
                    output = null;
                    break;
                }
                case 1: {
                    output = list.get(0);
                    break;
                }
                default: {
                    output = list;
                }
            }
            map.put(entry.getKey(), output);
        }
        return map;
    }

    public static Map<String, Object> getInputMap(Message message, KnowledgeOperation operation, KnowledgeRuntimeEngine runtime) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<ExpressionMapping> inputs = operation.getInputExpressionMappings();
        if (inputs.size() > 0) {
            map.putAll(KnowledgeOperations.getMap(message, inputs, null));
        } else {
            Object content = KnowledgeOperations.filterRemoteDefaultInputContent(message.getContent(), runtime);
            if (content != null) {
                map.put("Parameter", content);
            }
        }
        return map;
    }

    private static Object filterRemoteDefaultInputContent(Object content, KnowledgeRuntimeEngine runtime) {
        if (runtime.isRemote() && content != null && content.getClass().getAnnotation(XmlType.class) == null) {
            content = null;
        }
        return content;
    }

    public static void setOutputs(Message message, KnowledgeOperation operation, Map<String, Object> contextOverrides) {
        KnowledgeOperations.setOutputsOrFaults(message, operation.getOutputExpressionMappings(), contextOverrides, "Result");
    }

    public static void setFaults(Message message, KnowledgeOperation operation, Map<String, Object> contextOverrides) {
        KnowledgeOperations.setOutputsOrFaults(message, operation.getFaultExpressionMappings(), contextOverrides, "Fault");
    }

    private static void setOutputsOrFaults(Message message, List<ExpressionMapping> expressionMappings, Map<String, Object> expressionVariables, String defaultReturnVariable) {
        HashMap<String, ArrayList<ExpressionMapping>> toListMap = new HashMap<String, ArrayList<ExpressionMapping>>();
        for (ExpressionMapping expressionMapping : expressionMappings) {
            String to = expressionMapping.getTo();
            if (to == null) continue;
            ArrayList<ExpressionMapping> toList = (ArrayList<ExpressionMapping>)toListMap.get(to);
            if (toList == null) {
                toList = new ArrayList<ExpressionMapping>();
                toListMap.put(to, toList);
            }
            toList.add(expressionMapping);
        }
        if (toListMap.size() == 0) {
            Object output = KnowledgeOperations.getValue(expressionVariables, defaultReturnVariable);
            if (output != null) {
                message.setContent(output);
            }
        } else {
            if (!expressionVariables.containsKey(defaultReturnVariable)) {
                expressionVariables.put(defaultReturnVariable, null);
            }
            for (Map.Entry entry : toListMap.entrySet()) {
                ArrayList<Object> output;
                ArrayList<Object> from_list = new ArrayList<Object>();
                ExpressionMapping to_em = null;
                for (ExpressionMapping from_em : (List)entry.getValue()) {
                    Object from_value;
                    if (to_em == null) {
                        to_em = from_em;
                    }
                    if ((from_value = KnowledgeOperations.run(message, from_em.getFromExpression(), expressionVariables)) != null) {
                        from_list.add(from_value);
                        continue;
                    }
                    from_value = KnowledgeOperations.getValue(expressionVariables, from_em.getFrom());
                    if (from_value == null) continue;
                    from_list.add(from_value);
                }
                switch (from_list.size()) {
                    case 0: {
                        output = null;
                        break;
                    }
                    case 1: {
                        output = from_list.get(0);
                        break;
                    }
                    default: {
                        output = from_list;
                    }
                }
                String output_var = KnowledgeOperations.toVariable(output);
                expressionVariables.put(output_var, output);
                String output_to = to_em.getTo() + " = " + output_var;
                Expression output_to_expr = ExpressionFactory.INSTANCE.create(output_to, null, to_em.getPropertyResolver());
                KnowledgeOperations.run(message, output_to_expr, expressionVariables);
            }
        }
    }

    private static Object getValue(Map<String, Object> expressionVariables, String name) {
        Object globals;
        Object output = null;
        if (expressionVariables != null && (output = expressionVariables.get(name)) == null && (globals = expressionVariables.get("globals")) instanceof Map) {
            output = ((Map)globals).get(name);
        }
        return output;
    }

    private static List<Object> getList(Message message, List<ExpressionMapping> expressionMappings) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (expressionMappings == null || expressionMappings.size() == 0) {
            KnowledgeOperations.expand(message.getContent(), list);
        } else {
            Map<String, List<Object>> listMap = KnowledgeOperations.getListMap(message, expressionMappings, true, KnowledgeOperations.toVariable(message));
            for (List<Object> value : listMap.values()) {
                KnowledgeOperations.expand(value, list);
            }
        }
        return list;
    }

    private static Map<String, Object> getMap(Message message, List<ExpressionMapping> expressionMappings, Map<String, Object> contextOverrides) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, List<Object>> listMap = KnowledgeOperations.getListMap(message, expressionMappings, false, KnowledgeOperations.toVariable(message), contextOverrides);
        for (Map.Entry<String, List<Object>> entry : listMap.entrySet()) {
            List<Object> list = entry.getValue();
            map.put(entry.getKey(), list != null && list.size() > 0 ? list.get(0) : null);
        }
        return map;
    }

    public static Map<String, List<Object>> getListMap(Message message, List<ExpressionMapping> expressionMappings, boolean expand, String undefinedVariable) {
        return KnowledgeOperations.getListMap(message, expressionMappings, expand, undefinedVariable, null);
    }

    private static Map<String, List<Object>> getListMap(Message message, List<ExpressionMapping> expressionMappings, boolean expand, String undefinedVariable, Map<String, Object> expressionVariables) {
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        if (expressionMappings != null) {
            for (ExpressionMapping em : expressionMappings) {
                String variable = em.getTo();
                if (variable == null && undefinedVariable != null) {
                    variable = undefinedVariable;
                }
                if (variable == null) continue;
                ArrayList<Object> list = (ArrayList<Object>)map.get(variable);
                if (list == null) {
                    list = new ArrayList<Object>();
                    map.put(variable, list);
                }
                Object value = KnowledgeOperations.run(message, em.getFromExpression(), expressionVariables);
                if (expand) {
                    KnowledgeOperations.expand(value, list);
                    continue;
                }
                if (value == null) continue;
                list.add(value);
            }
        }
        return map;
    }

    private static Object run(Message message, Expression expression, Map<String, Object> expressionVariables) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (expressionVariables != null) {
            variables.putAll(expressionVariables);
        }
        variables.put("context", new ContextMap(message.getContext(), Scope.MESSAGE));
        variables.put("message", message);
        return expression.run(variables);
    }

    private static void expand(Object value, List<Object> list) {
        if (value != null) {
            if (value instanceof Iterable) {
                for (Object o : (Iterable)value) {
                    if (o == null) continue;
                    list.add(o);
                }
            } else {
                list.add(value);
            }
        }
    }

    public static String toVariable(Object object) {
        return ("_var" + System.identityHashCode(object)).replaceFirst("-", "_");
    }

    private KnowledgeOperations() {
    }
}

