/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.switchyard.component.common.knowledge.transaction.TransactionHelper;

public class TransactionInvocationHandler
implements InvocationHandler {
    private final Object _target;
    private final boolean _enabled;

    public TransactionInvocationHandler(Object target) {
        this(target, true);
    }

    public TransactionInvocationHandler(Object target, boolean enabled) {
        this._target = target;
        this._enabled = enabled;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret;
        if (this._target == null) {
            return null;
        }
        if (!this._enabled || Object.class.equals(method.getDeclaringClass())) {
            return method.invoke(this._target, args);
        }
        TransactionHelper utx = new TransactionHelper(this._enabled);
        try {
            utx.begin();
            ret = method.invoke(this._target, args);
            utx.commit();
        }
        catch (Throwable t) {
            utx.rollback();
            throw t;
        }
        return ret;
    }
}

