/*
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.switchyard.component.common.knowledge;

/**
 * Rules constants.
 *
 * @author David Ward &lt;<a href="mailto:dward@jboss.org">dward@jboss.org</a>&gt; &copy; 2012 Red Hat Inc.
 */
public final class KnowledgeConstants {

    /** default. */
    public static final String DEFAULT = "default";
    /** globals. */
    public static final String GLOBALS = "globals";
    /** context. */
    public static final String CONTEXT = "context";
    /** message. */
    public static final String MESSAGE = "message";

    /** Parameter. */
    public static final String PARAMETER = "Parameter";
    /** Result. */
    public static final String RESULT = "Result";
    /** Fault. */
    public static final String FAULT = "Fault";

    private KnowledgeConstants() {}

}
