/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.knowledge.runtime.remote;

import java.util.Map;
import java.util.WeakHashMap;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.services.client.api.command.RemoteConfiguration;
import org.switchyard.component.common.knowledge.runtime.remote.ExtendedRemoteRuntimeEngine;

public class RemoteRuntimeManager
implements RuntimeManager {
    private static final String NULL_CONTEXT_ID = "NullContext";
    private final RemoteConfiguration _configuration;
    private final String _identifier;
    private Map<Object, RuntimeEngine> _engines = new WeakHashMap<Object, RuntimeEngine>();

    public RemoteRuntimeManager(RemoteConfiguration configuration, String identifier) {
        this._configuration = configuration;
        this._identifier = identifier;
    }

    public synchronized RuntimeEngine getRuntimeEngine(Context<?> context) {
        Object engine;
        Object contextId;
        Object object = contextId = context != null ? context.getContextId() : null;
        if (contextId == null) {
            contextId = NULL_CONTEXT_ID;
        }
        if ((engine = this._engines.get(contextId)) == null) {
            engine = new ExtendedRemoteRuntimeEngine(this._configuration, context);
            this._engines.put(contextId, (RuntimeEngine)engine);
        }
        return engine;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public void disposeRuntimeEngine(RuntimeEngine runtime) {
    }

    public void close() {
    }
}

