/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.util.ArrayList;
import java.util.Arrays;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.rules.util.drools.ComponentImplementationConfig;
import org.switchyard.component.common.rules.util.drools.Configs;
import org.switchyard.component.common.rules.util.drools.Resources;

public final class Bases {
    public static KnowledgeBase newBase(ComponentImplementationConfig cic, Resource ... additionalResources) {
        ClassLoader loader;
        KnowledgeBaseConfiguration kbaseConfig = Configs.getBaseConfiguration(cic);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConfig);
        KnowledgeBuilderConfiguration kbuilderConfig = Configs.getBuilderConfiguration(cic);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)kbase, (KnowledgeBuilderConfiguration)kbuilderConfig);
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.addAll(cic.getModel().getResources());
        if (additionalResources != null) {
            resources.addAll(Arrays.asList(additionalResources));
        }
        if ((loader = cic.getLoader()) == null) {
            loader = Classes.getClassLoader(Bases.class);
        }
        for (Resource resource : resources) {
            Resources.add(resource, kbuilder, loader);
        }
        return kbuilder.newKnowledgeBase();
    }

    private Bases() {
    }
}

