/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.definition.KnowledgePackage;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.SimpleResource;
import org.switchyard.component.common.rules.util.drools.Resources;

public final class Packages {
    public static KnowledgePackage create(File src) throws IOException {
        return Packages.create((Resource)new SimpleResource(src.toURI().toURL().toString()));
    }

    public static KnowledgePackage create(Resource res) {
        return Packages.create(res, null);
    }

    public static KnowledgePackage create(Resource res, ClassLoader loader) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Resources.add(res, kbuilder, loader);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBaseFactory.newKnowledgeBase().addKnowledgePackages(kpkgs);
        return (KnowledgePackage)kpkgs.iterator().next();
    }

    public static KnowledgePackage write(File src, File dest) throws IOException {
        KnowledgePackage kpkg = Packages.create(src);
        Packages.write(kpkg, dest);
        return kpkg;
    }

    public static KnowledgePackage write(Resource res, File dest) throws IOException {
        return Packages.write(res, dest, null);
    }

    public static KnowledgePackage write(Resource res, File dest, ClassLoader loader) throws IOException {
        KnowledgePackage kpkg = Packages.create(res, loader);
        Packages.write(kpkg, dest);
        return kpkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(KnowledgePackage kpkg, File dest) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new DroolsObjectOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(dest)));
            oos.writeObject(kpkg);
        }
        finally {
            if (oos != null) {
                try {
                    oos.flush();
                    oos.close();
                }
                catch (Throwable t) {
                    t.getMessage();
                }
            }
        }
    }

    public static void main(String ... args) throws Exception {
        String cmd;
        if (args.length != 3) {
            Packages.throwUsage();
        }
        if ("write".equals(cmd = args[0].trim().toLowerCase())) {
            File src = new File(args[1]);
            File dest = new File(args[2]);
            System.out.printf("%s: Creating KnowledgePackage from [%s] and writing to [%s].", Packages.class.getSimpleName(), src.getPath(), dest.getPath());
            Packages.write(src, dest);
        } else {
            Packages.throwUsage();
        }
    }

    private static void throwUsage() {
        String usage = String.format("Usage: %s write <src .drl> <dest .pkg>", Packages.class.getName());
        throw new IllegalArgumentException(usage);
    }

    private Packages() {
    }
}

