/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.expression;

import org.switchyard.component.common.rules.config.model.MappingModel;
import org.switchyard.component.common.rules.expression.Expression;
import org.switchyard.component.common.rules.expression.ExpressionType;
import org.switchyard.component.common.rules.expression.MVELExpression;

public final class ExpressionFactory {
    private static final ExpressionFactory INSTANCE = new ExpressionFactory();

    private ExpressionFactory() {
    }

    public Expression create(String expression, ExpressionType expressionType) {
        switch (expressionType) {
            case MVEL: {
                return new MVELExpression(expression);
            }
        }
        throw new IllegalArgumentException("Unknown expressionType: " + (Object)((Object)expressionType));
    }

    public Expression create(MappingModel mappingModel) {
        return this.create(mappingModel.getExpression(), mappingModel.getExpressionType());
    }

    public static ExpressionFactory instance() {
        return INSTANCE;
    }
}

