/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.List;
import org.apache.log4j.Logger;
import org.drools.ChangeSet;
import org.drools.builder.ResourceType;
import org.drools.xml.ChangeSetSemanticModule;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.drools.xml.XmlChangeSetReader;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.rules.util.drools.Resources;
import org.switchyard.config.ConfigurationPuller;
import org.switchyard.exception.SwitchYardException;
import org.xml.sax.SAXException;

public final class ChangeSets {
    private static final Logger LOGGER = Logger.getLogger(ChangeSets.class);

    public static ChangeSet newChangeSet(List<? extends Resource> resources) {
        return ChangeSets.newChangeSet(resources, null);
    }

    public static ChangeSet newChangeSet(List<? extends Resource> resources, ClassLoader loader) {
        StringBuilder xml = new StringBuilder();
        if (loader == null) {
            loader = Classes.getClassLoader(ChangeSets.class);
        }
        xml.append("<change-set xmlns=\"http://drools.org/drools-5.0/change-set\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" xs:schemaLocation=\"http://drools.org/drools-5.0/change-set https://raw.github.com/droolsjbpm/droolsjbpm-knowledge/master/knowledge-api/src/main/resources/change-set-1.0.0.xsd\">");
        xml.append("<add>");
        if (resources != null) {
            for (Resource resource : resources) {
                if (resource == null) continue;
                URL url = resource.getLocationURL(loader);
                ResourceType type = Resources.convert(resource.getType());
                if (url == null || type == null) continue;
                xml.append(String.format("<resource source=\"%s\" type=\"%s\"/>", url, type.getName()));
            }
        }
        xml.append("</add>");
        xml.append("</change-set>");
        return ChangeSets.newChangeSet(xml.toString(), loader);
    }

    public static ChangeSet newChangeSet(String xml) {
        return ChangeSets.newChangeSet(xml, null);
    }

    public static ChangeSet newChangeSet(String xml, ClassLoader loader) {
        if (LOGGER.isDebugEnabled()) {
            String xcs;
            try {
                xcs = new ConfigurationPuller().pull((Reader)new StringReader(xml)).toString();
            }
            catch (IOException ioe) {
                xcs = xml;
            }
            LOGGER.debug((Object)("newChangeSet:\n" + xcs));
        }
        SemanticModules semanticModules = new SemanticModules();
        semanticModules.addSemanticModule((SemanticModule)new ChangeSetSemanticModule());
        XmlChangeSetReader reader = new XmlChangeSetReader(semanticModules);
        if (loader == null) {
            loader = Classes.getClassLoader(ChangeSets.class);
        }
        reader.setClassLoader(loader, null);
        try {
            return reader.read((Reader)new StringReader(xml));
        }
        catch (SAXException saxe) {
            throw new SwitchYardException((Throwable)saxe);
        }
        catch (IOException ioe) {
            throw new SwitchYardException((Throwable)ioe);
        }
    }

    private ChangeSets() {
    }
}

