/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.ChangeSet;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.util.drools.ChangeSets;
import org.switchyard.component.common.rules.util.drools.ComponentImplementationConfig;
import org.switchyard.component.common.rules.util.drools.Configs;

public final class Agents {
    private static AtomicInteger _nameCounter = new AtomicInteger();

    public static KnowledgeAgent newAgent(ComponentImplementationConfig cic, Resource ... additionalResources) {
        ClassLoader loader;
        String name;
        ComponentImplementationModel model = cic.getModel();
        try {
            name = model.getComponent().getComposite().getName();
        }
        catch (NullPointerException npe) {
            name = null;
        }
        name = Strings.trimToNull((String)name);
        if (name == null) {
            name = Agents.class.getSimpleName();
        }
        name = name + "-" + _nameCounter.incrementAndGet();
        KnowledgeBaseConfiguration kbaseConfig = Configs.getBaseConfiguration(cic);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConfig);
        KnowledgeAgentConfiguration kagentConfig = Configs.getAgentConfiguration(cic);
        KnowledgeBuilderConfiguration kbuilderConfig = Configs.getBuilderConfiguration(cic);
        KnowledgeAgent kagent = KnowledgeAgentFactory.newKnowledgeAgent((String)name, (KnowledgeBase)kbase, (KnowledgeAgentConfiguration)kagentConfig, (KnowledgeBuilderConfiguration)kbuilderConfig);
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.addAll(model.getResources());
        if (additionalResources != null) {
            for (Resource additionalResource : additionalResources) {
                if (additionalResource == null) continue;
                resources.add(additionalResource);
            }
        }
        if ((loader = cic.getLoader()) == null) {
            loader = Classes.getClassLoader(Agents.class);
        }
        ChangeSet changeSet = ChangeSets.newChangeSet(resources, loader);
        kagent.applyChangeSet(changeSet);
        return kagent;
    }

    private Agents() {
    }
}

