/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.util.Properties;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.KnowledgeAgentFactory;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.conf.MaxThreadsOption;
import org.drools.conf.MultithreadEvaluationOption;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.switchyard.common.type.Classes;
import org.switchyard.component.common.rules.ClockType;
import org.switchyard.component.common.rules.EventProcessingType;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.util.drools.ComponentImplementationConfig;
import org.switchyard.component.common.rules.util.drools.Environments;

public final class Configs {
    public static KnowledgeBaseConfiguration getBaseConfiguration(ComponentImplementationConfig cic) {
        EventProcessingType eventProcessing;
        KnowledgeBaseConfiguration kbaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration((Properties)Configs.getProperties(cic), (ClassLoader[])new ClassLoader[]{Configs.getLoader(cic)});
        ComponentImplementationModel model = cic.getModel();
        Boolean multithreadEvaluation = model.getMultithreadEvaluation();
        if (multithreadEvaluation != null) {
            Integer maxThreads;
            boolean me = multithreadEvaluation;
            MultithreadEvaluationOption meo = me ? MultithreadEvaluationOption.YES : MultithreadEvaluationOption.NO;
            kbaseConfig.setOption((KnowledgeBaseOption)meo);
            if (me && (maxThreads = model.getMaxThreads()) != null) {
                kbaseConfig.setOption((KnowledgeBaseOption)MaxThreadsOption.get((int)maxThreads));
            }
        }
        if ((eventProcessing = model.getEventProcessing()) != null) {
            switch (eventProcessing) {
                case CLOUD: {
                    kbaseConfig.setOption((KnowledgeBaseOption)EventProcessingOption.CLOUD);
                    break;
                }
                case STREAM: {
                    kbaseConfig.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
                }
            }
        }
        return kbaseConfig;
    }

    public static KnowledgeAgentConfiguration getAgentConfiguration(ComponentImplementationConfig cic) {
        return KnowledgeAgentFactory.newKnowledgeAgentConfiguration((Properties)Configs.getProperties(cic));
    }

    public static KnowledgeBuilderConfiguration getBuilderConfiguration(ComponentImplementationConfig cic) {
        return KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)Configs.getProperties(cic), (ClassLoader[])new ClassLoader[]{Configs.getLoader(cic)});
    }

    public static KnowledgeSessionConfiguration getSessionConfiguration(ComponentImplementationConfig cic) {
        KnowledgeSessionConfiguration ksessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration((Properties)Configs.getProperties(cic));
        ClockType clock = cic.getModel().getClock();
        if (clock != null) {
            switch (clock) {
                case REALTIME: {
                    ksessionConfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)org.drools.ClockType.REALTIME_CLOCK.getId()));
                    break;
                }
                case PSEUDO: {
                    ksessionConfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)org.drools.ClockType.PSEUDO_CLOCK.getId()));
                }
            }
        }
        return ksessionConfig;
    }

    private static Properties getProperties(ComponentImplementationConfig cic) {
        return Environments.getProperties(cic);
    }

    private static ClassLoader getLoader(ComponentImplementationConfig cic) {
        ClassLoader loader = cic.getLoader();
        if (loader == null) {
            loader = Classes.getClassLoader(Configs.class);
        }
        return loader;
    }

    private Configs() {
    }
}

