/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.drools.RuleBase;
import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.knowledgebase.KnowledgeBaseEventListener;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.reteoo.ReteooWorkingMemoryInterface;
import org.drools.runtime.process.InternalProcessRuntime;
import org.switchyard.common.type.reflect.Construction;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.config.model.EventListenerModel;
import org.switchyard.component.common.rules.util.drools.ComponentImplementationConfig;

public final class Events {
    private static final Logger LOGGER = Logger.getLogger(Events.class);

    public static final List<EventListener> addEventListeners(ComponentImplementationConfig cic, KnowledgeRuntimeEventManager krem) {
        ComponentImplementationModel cim;
        ArrayList<EventListener> list = new ArrayList<EventListener>();
        if (cic != null && (cim = cic.getModel()) != null) {
            for (EventListenerModel elm : cim.getEventListeners()) {
                EventListener el;
                Class<? extends EventListener> elc;
                ClassLoader loader = cic.getLoader();
                if (loader == null) {
                    loader = Events.class.getClassLoader();
                }
                if ((elc = elm.getClazz(loader)) == null) continue;
                try {
                    Constructor<? extends EventListener> cnstr = elc.getDeclaredConstructor(KnowledgeRuntimeEventManager.class);
                    el = (EventListener)Construction.construct(elc, (Class[])new Class[]{KnowledgeRuntimeEventManager.class}, (Object[])new Object[]{krem});
                }
                catch (NoSuchMethodException nsme1) {
                    try {
                        Constructor<? extends EventListener> cnstr = elc.getDeclaredConstructor(new Class[0]);
                        el = (EventListener)Construction.construct(elc);
                        Events.registerEventListener(el, krem);
                    }
                    catch (NoSuchMethodException nsme2) {
                        el = null;
                    }
                }
                if (el != null) {
                    list.add(el);
                    continue;
                }
                LOGGER.error((Object)("Could not find appropriate constructor in class " + elc.getName()));
            }
        }
        return list;
    }

    private static final void registerEventListener(EventListener el, KnowledgeRuntimeEventManager krem) {
        if (krem instanceof StatefulKnowledgeSessionImpl) {
            InternalProcessRuntime processRuntime;
            StatefulKnowledgeSessionImpl sksi = (StatefulKnowledgeSessionImpl)krem;
            ReteooWorkingMemoryInterface wmem = sksi.session;
            if (el instanceof org.drools.event.WorkingMemoryEventListener) {
                wmem.addEventListener((org.drools.event.WorkingMemoryEventListener)el);
            } else if (el instanceof WorkingMemoryEventListener) {
                krem.addEventListener((WorkingMemoryEventListener)el);
            }
            if (el instanceof org.drools.event.AgendaEventListener) {
                wmem.addEventListener((org.drools.event.AgendaEventListener)el);
            } else if (el instanceof AgendaEventListener) {
                krem.addEventListener((AgendaEventListener)el);
            }
            if (el instanceof RuleBaseEventListener) {
                wmem.addEventListener((RuleBaseEventListener)el);
            } else if (el instanceof KnowledgeBaseEventListener) {
                sksi.getKnowledgeBase().addEventListener((KnowledgeBaseEventListener)el);
            }
            if (el instanceof ProcessEventListener && (processRuntime = sksi.session.getProcessRuntime()) != null) {
                processRuntime.addEventListener((ProcessEventListener)el);
            }
        } else if (krem instanceof StatelessKnowledgeSessionImpl) {
            StatelessKnowledgeSessionImpl sksi = (StatelessKnowledgeSessionImpl)krem;
            if (el instanceof org.drools.event.WorkingMemoryEventListener) {
                sksi.workingMemoryEventSupport.addEventListener((EventListener)((org.drools.event.WorkingMemoryEventListener)el));
            } else if (el instanceof WorkingMemoryEventListener) {
                krem.addEventListener((WorkingMemoryEventListener)el);
            }
            if (el instanceof org.drools.event.AgendaEventListener) {
                sksi.agendaEventSupport.addEventListener((EventListener)((org.drools.event.AgendaEventListener)el));
            } else if (el instanceof AgendaEventListener) {
                krem.addEventListener((AgendaEventListener)el);
            }
            if (el instanceof RuleBaseEventListener) {
                sksi.getRuleBase().addEventListener((RuleBaseEventListener)el);
            } else if (el instanceof KnowledgeBaseEventListener) {
                new KnowledgeBaseImpl((RuleBase)sksi.getRuleBase()).addEventListener((KnowledgeBaseEventListener)el);
            }
            if (el instanceof ProcessEventListener) {
                sksi.processEventSupport.addEventListener((EventListener)((ProcessEventListener)el));
            }
        } else if (krem instanceof CommandBasedStatefulKnowledgeSession) {
            InternalProcessRuntime ipr;
            CommandBasedStatefulKnowledgeSession cbsks = (CommandBasedStatefulKnowledgeSession)krem;
            ReteooWorkingMemoryInterface rwmi = ((StatefulKnowledgeSessionImpl)((KnowledgeCommandContext)cbsks.getCommandService().getContext()).getStatefulKnowledgesession()).session;
            if (el instanceof org.drools.event.WorkingMemoryEventListener) {
                rwmi.addEventListener((org.drools.event.WorkingMemoryEventListener)el);
            } else if (el instanceof WorkingMemoryEventListener) {
                krem.addEventListener((WorkingMemoryEventListener)el);
            }
            if (el instanceof org.drools.event.AgendaEventListener) {
                rwmi.addEventListener((org.drools.event.AgendaEventListener)el);
            } else if (el instanceof AgendaEventListener) {
                krem.addEventListener((AgendaEventListener)el);
            }
            if (el instanceof RuleBaseEventListener) {
                rwmi.addEventListener((RuleBaseEventListener)el);
            } else if (el instanceof KnowledgeBaseEventListener) {
                cbsks.getKnowledgeBase().addEventListener((KnowledgeBaseEventListener)el);
            }
            if (el instanceof ProcessEventListener && (ipr = rwmi.getProcessRuntime()) != null) {
                ipr.addEventListener((ProcessEventListener)el);
            }
        }
    }

    private Events() {
    }
}

