/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import org.apache.commons.lang.text.StrSubstitutor;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactory;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.rules.AuditType;
import org.switchyard.component.common.rules.config.model.AuditModel;

public final class Audits {
    public static KnowledgeRuntimeLogger getLogger(AuditModel audit, KnowledgeRuntimeEventManager ksession) {
        if (audit != null) {
            String log;
            AuditType type = audit.getType();
            if (type == null) {
                type = AuditType.THREADED_FILE;
            }
            String fileName = (log = Strings.trimToNull((String)audit.getLog())) != null ? StrSubstitutor.replaceSystemProperties((Object)log) : "event";
            Integer interval = audit.getInterval();
            if (interval == null) {
                interval = 1000;
            }
            switch (type) {
                case CONSOLE: {
                    return KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)ksession);
                }
                case FILE: {
                    return KnowledgeRuntimeLoggerFactory.newFileLogger((KnowledgeRuntimeEventManager)ksession, (String)fileName);
                }
                case THREADED_FILE: {
                    return KnowledgeRuntimeLoggerFactory.newThreadedFileLogger((KnowledgeRuntimeEventManager)ksession, (String)fileName, (int)interval);
                }
            }
        }
        return null;
    }

    private Audits() {
    }
}

