/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.config.model.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.component.common.rules.ClockType;
import org.switchyard.component.common.rules.EventProcessingType;
import org.switchyard.component.common.rules.config.model.AuditModel;
import org.switchyard.component.common.rules.config.model.ComponentImplementationModel;
import org.switchyard.component.common.rules.config.model.EventListenerModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Marshaller;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.resource.ResourceModel;

public abstract class V1ComponentImplementationModel
extends org.switchyard.config.model.composite.v1.V1ComponentImplementationModel
implements ComponentImplementationModel {
    private AuditModel _audit;
    private List<EventListenerModel> _eventListeners = new ArrayList<EventListenerModel>();
    private List<ResourceModel> _resources = new ArrayList<ResourceModel>();

    public V1ComponentImplementationModel(String type) {
        super(type);
    }

    public V1ComponentImplementationModel(String type, String namespace) {
        super(type, namespace);
    }

    public V1ComponentImplementationModel(Configuration config, Descriptor desc) {
        super(config, desc);
        Marshaller marsh;
        ClassLoader modelLoader = V1ComponentImplementationModel.class.getClassLoader();
        for (Configuration eventListener_config : config.getChildren("eventListener")) {
            marsh = desc.getMarshaller(eventListener_config.getQName().getNamespaceURI(), modelLoader);
            EventListenerModel eventListener = (EventListenerModel)marsh.read(eventListener_config);
            if (eventListener == null) continue;
            this._eventListeners.add(eventListener);
        }
        for (Configuration resource_config : config.getChildren("resource")) {
            marsh = desc.getMarshaller(resource_config.getQName().getNamespaceURI(), modelLoader);
            ResourceModel resource = (ResourceModel)marsh.read(resource_config);
            if (resource == null) continue;
            this._resources.add(resource);
        }
    }

    @Override
    public boolean isAgent() {
        String agent = this.getModelAttribute("agent");
        return agent != null ? Boolean.valueOf(agent) : false;
    }

    @Override
    public V1ComponentImplementationModel setAgent(boolean agent) {
        this.setModelAttribute("agent", String.valueOf(agent));
        return this;
    }

    @Override
    public ClockType getClock() {
        String clock = this.getModelAttribute("clock");
        return clock != null ? ClockType.valueOf(clock) : null;
    }

    @Override
    public ComponentImplementationModel setClock(ClockType clock) {
        this.setModelAttribute("clock", clock != null ? clock.name() : null);
        return this;
    }

    @Override
    public EventProcessingType getEventProcessing() {
        String eventProcessing = this.getModelAttribute("eventProcessing");
        return eventProcessing != null ? EventProcessingType.valueOf(eventProcessing) : null;
    }

    @Override
    public ComponentImplementationModel setEventProcessing(EventProcessingType eventProcessing) {
        this.setModelAttribute("eventProcessing", eventProcessing != null ? eventProcessing.name() : null);
        return this;
    }

    @Override
    public Integer getMaxThreads() {
        String maxThreads = this.getModelAttribute("maxThreads");
        return maxThreads != null ? Integer.valueOf(maxThreads) : null;
    }

    @Override
    public ComponentImplementationModel setMaxThreads(Integer maxThreads) {
        this.setModelAttribute("maxThreads", maxThreads != null ? String.valueOf(maxThreads) : null);
        return this;
    }

    @Override
    public Boolean getMultithreadEvaluation() {
        String multithreadEvaluation = this.getModelAttribute("multithreadEvaluation");
        return multithreadEvaluation != null ? Boolean.valueOf(multithreadEvaluation) : null;
    }

    @Override
    public ComponentImplementationModel setMultithreadEvaluation(Boolean multithreadEvaluation) {
        this.setModelAttribute("multithreadEvaluation", multithreadEvaluation != null ? String.valueOf(multithreadEvaluation) : null);
        return this;
    }

    @Override
    public AuditModel getAudit() {
        if (this._audit == null) {
            this._audit = (AuditModel)this.getFirstChildModelStartsWith("audit");
        }
        return this._audit;
    }

    @Override
    public V1ComponentImplementationModel setAudit(AuditModel audit) {
        this.setChildModel(audit);
        this._audit = audit;
        return this;
    }

    @Override
    public List<EventListenerModel> getEventListeners() {
        return Collections.unmodifiableList(this._eventListeners);
    }

    @Override
    public ComponentImplementationModel addEventListener(EventListenerModel eventListener) {
        this.addChildModel(eventListener);
        this._eventListeners.add(eventListener);
        return this;
    }

    @Override
    public List<ResourceModel> getResources() {
        return Collections.unmodifiableList(this._resources);
    }

    @Override
    public V1ComponentImplementationModel addResource(ResourceModel resource) {
        this.addChildModel((Model)resource);
        this._resources.add(resource);
        return this;
    }
}

