/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;

public class ContextMap
implements Context,
Map<String, Object> {
    private final Context _context;
    private final Scope _scope;

    public ContextMap(Context context) {
        this(context, Scope.IN);
    }

    public ContextMap(Context context, Scope scope) {
        this._context = context;
        this._scope = scope;
    }

    public Property getProperty(String name) {
        return this._context.getProperty(name);
    }

    public Property getProperty(String name, Scope scope) {
        return this._context.getProperty(name, scope);
    }

    public Object getPropertyValue(String name) {
        return this._context.getPropertyValue(name);
    }

    public Set<Property> getProperties() {
        return this._context.getProperties();
    }

    public Set<Property> getProperties(Scope scope) {
        return this._context.getProperties(scope);
    }

    public void removeProperty(Property property) {
        this._context.removeProperty(property);
    }

    public void removeProperties() {
        this._context.removeProperties();
    }

    public void removeProperties(Scope scope) {
        this._context.removeProperties(scope);
    }

    public Property setProperty(String name, Object val) {
        return this._context.setProperty(name, val);
    }

    public Property setProperty(String name, Object val, Scope scope) {
        return this._context.setProperty(name, val, scope);
    }

    public Context setProperties(Set<Property> properties) {
        this._context.setProperties(properties);
        return this;
    }

    @Override
    public int size() {
        return this.getProperties(this._scope).size();
    }

    @Override
    public boolean isEmpty() {
        return this.getProperties(this._scope).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null ? this.getProperty(key.toString(), this._scope) != null : false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (Property property : this.getProperties(this._scope)) {
                if (!value.equals(property.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Property property;
        if (key != null && (property = this.getProperty(key.toString(), this._scope)) != null) {
            return property.getValue();
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        return this.setProperty(key, value, this._scope);
    }

    @Override
    public Object remove(Object key) {
        Property property;
        if (key != null && (property = this.getProperty(key.toString(), this._scope)) != null) {
            this.removeProperty(property);
            return property.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue(), this._scope);
        }
    }

    @Override
    public void clear() {
        this.removeProperties(this._scope);
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (Property property : this.getProperties(this._scope)) {
            keySet.add(property.getName());
        }
        return keySet;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Property property : this.getProperties(this._scope)) {
            values.add(property.getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> entries = new HashMap<String, Object>();
        for (Property property : this.getProperties(this._scope)) {
            entries.put(property.getName(), property.getValue());
        }
        return entries.entrySet();
    }
}

