/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.drools.SystemEventListener;
import org.switchyard.common.lang.Strings;

public class LogSystemEventListener
implements SystemEventListener {
    private static final Logger LOGGER = Logger.getLogger(LogSystemEventListener.class);
    private String _messagePrefix;

    public LogSystemEventListener() {
        this(null);
    }

    public LogSystemEventListener(String messagePrefix) {
        this.setMessagePrefix(messagePrefix);
    }

    protected final String getMessagePrefix() {
        return this._messagePrefix;
    }

    protected final LogSystemEventListener setMessagePrefix(String messagePrefix) {
        this._messagePrefix = (messagePrefix = Strings.trimToNull((String)messagePrefix)) != null ? messagePrefix + ": " : "";
        return this;
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private final String format(String message) {
        return this.getMessagePrefix() + String.valueOf(message);
    }

    private final String format(String message, Object object) {
        return this.format(message) + " - Object[" + String.valueOf(object) + "]";
    }

    public final void info(String message) {
        this.debug(message);
    }

    public final void info(String message, Object object) {
        this.debug(message, object);
    }

    public final void warning(String message) {
        if (this.getLogger().isEnabledFor((Priority)Level.WARN)) {
            this.getLogger().warn((Object)this.format(message));
        }
    }

    public final void warning(String message, Object object) {
        if (this.getLogger().isEnabledFor((Priority)Level.WARN)) {
            this.getLogger().warn((Object)this.format(message, object));
        }
    }

    public final void exception(Throwable e) {
        if (this.getLogger().isEnabledFor((Priority)Level.ERROR)) {
            this.getLogger().error((Object)this.format(e.getMessage()), e);
        }
    }

    public final void exception(String message, Throwable e) {
        if (this.getLogger().isEnabledFor((Priority)Level.ERROR)) {
            this.getLogger().error((Object)this.format(message), e);
        }
    }

    public final void debug(String message) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)this.format(message));
        }
    }

    public final void debug(String message, Object object) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)this.format(message, object));
        }
    }
}

