/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.rules.util.drools;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.impl.PrintStreamSystemEventListener;
import org.drools.core.util.DelegatingSystemEventListener;
import org.drools.io.ResourceChangeScanner;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.ResourceFactory;
import org.switchyard.common.lang.Strings;
import org.switchyard.component.common.rules.util.drools.LogSystemEventListener;
import org.switchyard.deploy.Component;

public final class ResourceChangeService {
    private static final Logger LOGGER = Logger.getLogger(ResourceChangeService.class);
    public static final String DROOLS_RESOURCE_SCANNER_INTERVAL = "drools.resource.scanner.interval";
    private static Set<String> _names = Collections.synchronizedSet(new HashSet());
    private static SystemEventListener _originalSystemEventListener = null;
    private static boolean _running = false;

    public static void start(Component component) {
        ResourceChangeService.start(component.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void start(String name) {
        try {
            if (_names.size() == 0 && !_running) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Starting resource change service...");
                }
                if ((_originalSystemEventListener = SystemEventListenerFactory.getSystemEventListener()) == null || _originalSystemEventListener instanceof DelegatingSystemEventListener) {
                    _originalSystemEventListener = new PrintStreamSystemEventListener();
                }
                SystemEventListenerFactory.setSystemEventListener((SystemEventListener)new LogSystemEventListener());
                ResourceFactory.getResourceChangeNotifierService().start();
                ResourceChangeScanner rcs = ResourceFactory.getResourceChangeScannerService();
                String drsi = Strings.trimToNull((String)System.getProperty(DROOLS_RESOURCE_SCANNER_INTERVAL));
                if (drsi != null && !drsi.equals("60")) {
                    ResourceChangeScannerConfiguration rcs_conf = rcs.newResourceChangeScannerConfiguration();
                    rcs_conf.setProperty(DROOLS_RESOURCE_SCANNER_INTERVAL, drsi);
                    rcs.configure(rcs_conf);
                }
                rcs.start();
                _running = true;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Resource change service started.");
                }
            }
        }
        finally {
            _names.add(name);
        }
    }

    public static void stop(Component component) {
        ResourceChangeService.stop(component.getName());
    }

    public static synchronized void stop(String name) {
        _names.remove(name);
        if (_names.size() == 0 && _running) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Stopping resource change service...");
            }
            ResourceFactory.getResourceChangeScannerService().stop();
            ResourceFactory.getResourceChangeNotifierService().stop();
            SystemEventListenerFactory.setSystemEventListener((SystemEventListener)_originalSystemEventListener);
            _originalSystemEventListener = null;
            _running = false;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Resource change service stopped.");
            }
        }
    }

    private ResourceChangeService() {
    }
}

