/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.composer;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.ContextMapper;
import org.switchyard.component.common.composer.RegexContextMapper;
import org.switchyard.config.model.composer.ContextMapperModel;

public abstract class ContextMapperFactory<D extends BindingData> {
    private static final Logger LOGGER = Logger.getLogger(ContextMapperFactory.class);

    public abstract Class<D> getBindingDataClass();

    public abstract ContextMapper<D> newContextMapperDefault();

    public final ContextMapper<D> newContextMapper(ContextMapperModel model) {
        ContextMapper<D> contextMapper = null;
        ContextMapperFactory<D> contextMapperFactory = ContextMapperFactory.getContextMapperFactory(this.getBindingDataClass());
        if (model != null) {
            contextMapper = contextMapperFactory.newContextMapper(model.getClazz());
            if (contextMapper instanceof RegexContextMapper) {
                RegexContextMapper regexContextMapper = (RegexContextMapper)contextMapper;
                regexContextMapper.setIncludes(model.getIncludes());
                regexContextMapper.setExcludes(model.getExcludes());
                regexContextMapper.setIncludeNamespaces(model.getIncludeNamespaces());
                regexContextMapper.setExcludeNamespaces(model.getExcludeNamespaces());
            }
        } else {
            contextMapper = contextMapperFactory.newContextMapperDefault();
        }
        return contextMapper;
    }

    public final ContextMapper<D> newContextMapper(Class<? extends ContextMapper<D>> custom) {
        ContextMapper<D> contextMapper = null;
        if (custom != null) {
            try {
                contextMapper = custom.newInstance();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Could not instantiate ContextMapper: " + custom.getClass().getName() + " - " + e.getMessage()));
            }
        }
        if (contextMapper == null) {
            contextMapper = this.newContextMapperDefault();
        }
        return contextMapper;
    }

    public static final <F extends BindingData> ContextMapperFactory<F> getContextMapperFactory(Class<F> targetClass) {
        return ContextMapperFactory.getContextMapperFactories().get(targetClass);
    }

    public static final Map<Class, ContextMapperFactory> getContextMapperFactories() {
        HashMap<Class, ContextMapperFactory> factories = new HashMap<Class, ContextMapperFactory>();
        ServiceLoader<ContextMapperFactory> services = ServiceLoader.load(ContextMapperFactory.class);
        for (ContextMapperFactory factory : services) {
            factories.put(factory.getBindingDataClass(), factory);
        }
        return factories;
    }
}

