/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.selector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.switchyard.component.common.selector.config.model.OperationSelectorModel;
import org.switchyard.component.common.selector.config.model.RegexOperationSelectorModel;
import org.switchyard.component.common.selector.config.model.StaticOperationSelectorModel;
import org.switchyard.component.common.selector.config.model.XPathOperationSelectorModel;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class OperationSelector<T> {
    private String _defaultNamespace;
    private OperationSelectorModel _model;

    public OperationSelector(OperationSelectorModel model) {
        this._model = model;
    }

    public QName selectOperation(T content) throws Exception {
        QName operationQName = null;
        if (this._model instanceof StaticOperationSelectorModel) {
            StaticOperationSelectorModel staticModel = (StaticOperationSelectorModel)StaticOperationSelectorModel.class.cast(this._model);
            operationQName = QName.valueOf(staticModel.getOperationName());
        } else if (this._model instanceof XPathOperationSelectorModel) {
            XPathOperationSelectorModel xpathModel = (XPathOperationSelectorModel)XPathOperationSelectorModel.class.cast(this._model);
            operationQName = this.xpathMatch(xpathModel.getExpression(), this.extractDomDocument(content));
        } else if (this._model instanceof RegexOperationSelectorModel) {
            RegexOperationSelectorModel regexModel = (RegexOperationSelectorModel)RegexOperationSelectorModel.class.cast(this._model);
            operationQName = this.regexMatch(regexModel.getExpression(), this.extractString(content));
        } else {
            throw new Exception("Unsupported OperationSelector configuration: " + this._model);
        }
        if (this._defaultNamespace != null && operationQName.getNamespaceURI().equals("")) {
            operationQName = new QName(this._defaultNamespace, operationQName.getLocalPart(), operationQName.getPrefix());
        }
        return operationQName;
    }

    public OperationSelector<T> setDefaultNamespace(String namespace) {
        this._defaultNamespace = namespace;
        return this;
    }

    protected abstract Document extractDomDocument(T var1) throws Exception;

    protected abstract String extractString(T var1) throws Exception;

    private QName xpathMatch(String expression, Document content) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NodeList result = null;
        try {
            XPathExpression expr = xpath.compile(expression);
            result = (NodeList)NodeList.class.cast(expr.evaluate(content, XPathConstants.NODESET));
        }
        catch (Exception e) {
            throw new Exception("Couldn't evaluate XPath expression '" + expression + "'", e);
        }
        if (result.getLength() == 1) {
            return QName.valueOf(result.item(0).getTextContent());
        }
        if (result.getLength() == 0) {
            throw new Exception("No node has been matched with the XPath expression '" + expression + "' in the payload. It couldn't determine the operation.");
        }
        throw new Exception("Multiple nodes have been matched with the XPath expression '" + expression + "' in the payload. It couldn't determine the operation.");
    }

    private QName regexMatch(String expression, String content) throws Exception {
        Pattern pattern = Pattern.compile(expression);
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            throw new Exception("No node has been matched with the Regex expression '" + expression + "' in the payload. It couldn't determine the operation.");
        }
        String operation = matcher.group();
        if (matcher.find()) {
            throw new Exception("Multiple nodes have been matched with the Regex expression '" + expression + "' in the payload. It couldn't determine the operation.");
        }
        return QName.valueOf(operation);
    }
}

