/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.selector;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.selector.JavaOperationSelectorModel;
import org.switchyard.config.model.selector.OperationSelectorModel;
import org.switchyard.selector.OperationSelector;

public abstract class OperationSelectorFactory<T> {
    private static final Logger LOGGER = Logger.getLogger(OperationSelectorFactory.class);

    public abstract Class<T> getTargetClass();

    public abstract Class<? extends OperationSelector<T>> getDefaultOperationSelectorClass();

    public final OperationSelector<T> newOperationSelector(OperationSelectorModel model) {
        if (model == null) {
            return null;
        }
        OperationSelectorFactory<T> operationSelectorFactory = OperationSelectorFactory.getOperationSelectorFactory(this.getTargetClass());
        if (model instanceof JavaOperationSelectorModel) {
            JavaOperationSelectorModel javaModel = (JavaOperationSelectorModel)JavaOperationSelectorModel.class.cast(model);
            return operationSelectorFactory.newOperationSelector(Classes.forName((String)javaModel.getClazz()), (OperationSelectorModel)javaModel);
        }
        return operationSelectorFactory.newOperationSelector(operationSelectorFactory.getDefaultOperationSelectorClass(), model);
    }

    public final OperationSelector<T> newOperationSelector(Class<? extends OperationSelector<T>> custom, OperationSelectorModel model) {
        OperationSelector<T> operationSelector = null;
        if (custom != null) {
            try {
                Constructor<OperationSelector<T>> constructor = custom.getConstructor(OperationSelectorModel.class);
                operationSelector = constructor.newInstance(model);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Could not instantiate OperationSelector: " + custom.getClass().getName() + " - " + e.getMessage()));
            }
        }
        return operationSelector;
    }

    public static final <F> OperationSelectorFactory<F> getOperationSelectorFactory(Class<F> targetClass) {
        return OperationSelectorFactory.getOperationSelectorFactories().get(targetClass);
    }

    public static final Map<Class, OperationSelectorFactory> getOperationSelectorFactories() {
        HashMap<Class, OperationSelectorFactory> factories = new HashMap<Class, OperationSelectorFactory>();
        ServiceLoader<OperationSelectorFactory> services = ServiceLoader.load(OperationSelectorFactory.class);
        for (OperationSelectorFactory factory : services) {
            factories.put(factory.getTargetClass(), factory);
        }
        return factories;
    }
}

