/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.common.selector;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.switchyard.component.common.CommonCommonMessages;
import org.switchyard.config.model.selector.OperationSelectorModel;
import org.switchyard.config.model.selector.RegexOperationSelectorModel;
import org.switchyard.config.model.selector.StaticOperationSelectorModel;
import org.switchyard.config.model.selector.XPathOperationSelectorModel;
import org.switchyard.selector.OperationSelector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class BaseOperationSelector<T>
implements OperationSelector<T> {
    private String _defaultNamespace;
    private OperationSelectorModel _model;

    public BaseOperationSelector(OperationSelectorModel model) {
        this._model = model;
    }

    public QName selectOperation(T content) throws Exception {
        QName operationQName = null;
        if (this._model instanceof StaticOperationSelectorModel) {
            StaticOperationSelectorModel staticModel = (StaticOperationSelectorModel)StaticOperationSelectorModel.class.cast(this._model);
            operationQName = QName.valueOf(staticModel.getOperationName());
        } else if (this._model instanceof XPathOperationSelectorModel) {
            XPathOperationSelectorModel xpathModel = (XPathOperationSelectorModel)XPathOperationSelectorModel.class.cast(this._model);
            operationQName = this.xpathMatch(xpathModel.getExpression(), this.extractDomDocument(content));
        } else if (this._model instanceof RegexOperationSelectorModel) {
            RegexOperationSelectorModel regexModel = (RegexOperationSelectorModel)RegexOperationSelectorModel.class.cast(this._model);
            operationQName = this.regexMatch(regexModel.getExpression(), this.extractString(content));
        } else {
            throw CommonCommonMessages.MESSAGES.unsupportedOperationSelectorConfiguration(this._model.toString());
        }
        if (this._defaultNamespace != null && operationQName.getNamespaceURI().equals("")) {
            operationQName = new QName(this._defaultNamespace, operationQName.getLocalPart(), operationQName.getPrefix());
        }
        return operationQName;
    }

    public String getDefaultNamespace() {
        return this._defaultNamespace;
    }

    public OperationSelector<T> setDefaultNamespace(String namespace) {
        this._defaultNamespace = namespace;
        return this;
    }

    protected abstract Document extractDomDocument(T var1) throws Exception;

    protected abstract String extractString(T var1) throws Exception;

    private QName xpathMatch(String expression, Document content) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NodeList result = null;
        try {
            XPathExpression expr = xpath.compile(expression);
            result = (NodeList)NodeList.class.cast(expr.evaluate(content, XPathConstants.NODESET));
        }
        catch (Exception e) {
            throw CommonCommonMessages.MESSAGES.couldnTEvaluateXPathExpression(expression, e);
        }
        if (result.getLength() == 1) {
            return QName.valueOf(result.item(0).getTextContent());
        }
        if (result.getLength() == 0) {
            throw CommonCommonMessages.MESSAGES.noNodeHasBeenMatchedWithTheXPathExpression(expression);
        }
        throw CommonCommonMessages.MESSAGES.multipleNodesHaveBeenMatchedWithTheXPathExpression(expression);
    }

    private QName regexMatch(String expression, String content) throws Exception {
        Pattern pattern = Pattern.compile(expression);
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            throw CommonCommonMessages.MESSAGES.noNodeHasBeenMatchedWithTheRegexExpression(expression);
        }
        String operation = matcher.group();
        if (matcher.find()) {
            throw CommonCommonMessages.MESSAGES.multipleNodesHaveBeenMatchedWithTheRegexExpression(expression);
        }
        return QName.valueOf(operation);
    }
}

