/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.ServerLocator;
import org.switchyard.component.hornetq.HornetQEndpoint;
import org.switchyard.component.hornetq.internal.HornetQUtil;

public class HornetQProducer
extends DefaultProducer {
    private final String _destination;
    private ClientSession _session;
    private ClientProducer _producer;
    private ServerLocator _serverLocator;
    private ClientSessionFactory _factory;
    private HornetQEndpoint _hornetQEndpoint;

    public HornetQProducer(HornetQEndpoint endpoint, ServerLocator serverLocator, String destination) {
        super((Endpoint)endpoint);
        this._hornetQEndpoint = endpoint;
        this._destination = destination;
        this._serverLocator = serverLocator;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._factory = this._serverLocator.createSessionFactory();
        this._session = this._hornetQEndpoint.isXASession() ? this._factory.createXASession() : this._factory.createSession();
        this._producer = this._session.createProducer(this._destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            super.doStop();
        }
        finally {
            HornetQUtil.closeClientProducer(this._producer);
            HornetQUtil.closeSession(this._session);
            HornetQUtil.closeSessionFactory(this._factory);
            HornetQUtil.closeServerLocator(this._serverLocator);
        }
    }

    public void process(Exchange exchange) throws Exception {
        Object body = exchange.getIn().getBody();
        ClientMessage message = this._session.createMessage(this._hornetQEndpoint.isDurable());
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOut);
        objectOutputStream.writeObject(body);
        message.getBodyBuffer().writeBytes(byteOut.toByteArray());
        this._producer.send((Message)message);
    }
}

