/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultComponent;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.switchyard.component.hornetq.HornetQEndpoint;
import org.switchyard.component.hornetq.ServerLocatorBuilder;

public class HornetQComponent
extends DefaultComponent {
    private ServerLocatorBuilder _serverLocatorBuilder = new ServerLocatorBuilder();

    protected Endpoint createEndpoint(String uri, String path, Map<String, Object> parameters) throws Exception {
        HornetQEndpoint endpoint = new HornetQEndpoint(path, uri, this, this._serverLocatorBuilder);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public void setTransportConfiguration(TransportConfiguration config) {
        this._serverLocatorBuilder.transportConfigurations(config);
    }

    public void setDiscoveryGroupConfiguration(DiscoveryGroupConfiguration config) {
        this._serverLocatorBuilder.discoveryGroupConfiguration(config);
    }

    public void setUseHA(Boolean useHA) {
        this._serverLocatorBuilder.useHA(useHA);
    }

    public void setDisableFinalizedCheck(Boolean disable) {
        this._serverLocatorBuilder.disableFinalizedCheck(disable);
    }

    public void setClientFailureCheckPeriod(Long period) {
        this._serverLocatorBuilder.clientFailureCheckPeriod(period);
    }

    public void setCacheLargeMessagesOnConsumer(Boolean cache) {
        this._serverLocatorBuilder.cacheLargeMessagesOnConsumers(cache);
    }

    public void setConnectionTTL(Long ttl) {
        this._serverLocatorBuilder.connectionTTL(ttl);
    }

    public void setCallTimeout(Long timeout) {
        this._serverLocatorBuilder.callTimeout(timeout);
    }

    public void setMinLargeMessageSize(Integer size) {
        this._serverLocatorBuilder.minLargeMessageSize(size);
    }

    public void setConsumerWindowSize(Integer size) {
        this._serverLocatorBuilder.consumerWindowSize(size);
    }

    public void setConsumerMaxRate(Integer rate) {
        this._serverLocatorBuilder.consumerMaxRate(rate);
    }

    public void setConfirmationWindowSize(Integer size) {
        this._serverLocatorBuilder.confirmationWindowSize(size);
    }

    public void setProducerWindowSize(Integer size) {
        this._serverLocatorBuilder.producerWindowSize(size);
    }

    public void setProducerMaxRate(Integer rate) {
        this._serverLocatorBuilder.producerMaxRate(rate);
    }

    public void setBlockOnAcknowledge(Boolean block) {
        this._serverLocatorBuilder.blockOnAcknowledge(block);
    }

    public void setBlockOnDurableSend(Boolean block) {
        this._serverLocatorBuilder.blockOnDurableSend(block);
    }

    public void setBlockOnNonDurableSend(Boolean block) {
        this._serverLocatorBuilder.blockOnNonDurableSend(block);
    }

    public void setAutoGroup(Boolean autoGroup) {
        this._serverLocatorBuilder.autoGroup(autoGroup);
    }

    public void setGroupID(String id) {
        this._serverLocatorBuilder.groupID(id);
    }

    public void setPreAcknowledge(Boolean preAck) {
        this._serverLocatorBuilder.preAcknowledge(preAck);
    }

    public void setAckBatchSize(Integer size) {
        this._serverLocatorBuilder.ackBatchSize(size);
    }

    public void setUseGlobalPools(Boolean useGlobalPools) {
        this._serverLocatorBuilder.useGlobalPools(useGlobalPools);
    }

    public void setScheduledThreadPoolMaxSize(Integer size) {
        this._serverLocatorBuilder.scheduledThreadPoolMaxSize(size);
    }

    public void setThreadPoolMaxSize(Integer size) {
        this._serverLocatorBuilder.threadPoolMaxSize(size);
    }

    public void setRetryInterval(Long interval) {
        this._serverLocatorBuilder.retryInterval(interval);
    }

    public void setRetryIntervalMultiplier(Double multiplier) {
        this._serverLocatorBuilder.retryIntervalMultiplier(multiplier);
    }

    public void setMaxRetryInterval(Long max) {
        this._serverLocatorBuilder.maxRetryInterval(max);
    }

    public void setReconnectAttempts(Integer attempts) {
        this._serverLocatorBuilder.reconnectAttempts(attempts);
    }

    public void setInitialReconnectAttempts(Integer attempts) {
        this._serverLocatorBuilder.initialReconnectAttempts(attempts);
    }

    public void setFailoverOnInitialConnection(Boolean failover) {
        this._serverLocatorBuilder.failoverOnInitialConnection(failover);
    }

    public void setConnectionLoadBalancingPolicyClassName(String className) {
        this._serverLocatorBuilder.connectionLoadBalancingPolicyClassName(className);
    }

    public void setInitialMessagePacketSize(Integer packetSize) {
        this._serverLocatorBuilder.initialMessagePacketSize(packetSize);
    }

    public void setCompessLargeMessage(Boolean compress) {
        this._serverLocatorBuilder.compressLargeMessage(compress);
    }
}

