/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.deploy;

import org.apache.log4j.Logger;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.api.core.client.ServerLocator;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.hornetq.composer.HornetQComposition;
import org.switchyard.component.hornetq.config.model.HornetQBindingModel;
import org.switchyard.component.hornetq.config.model.HornetQConfigModel;
import org.switchyard.component.hornetq.config.model.OperationSelector;
import org.switchyard.component.hornetq.internal.HornetQUtil;
import org.switchyard.composer.MessageComposer;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.SwitchYardException;

public class InboundHandler
extends BaseServiceHandler
implements MessageHandler {
    private Logger _logger = Logger.getLogger(InboundHandler.class);
    private final HornetQBindingModel _bindingModel;
    private final HornetQConfigModel _configModel;
    private final MessageComposer<ClientMessage> _messageComposer;
    private ClassLoader _applicationClassLoader = Thread.currentThread().getContextClassLoader();
    private ServiceReference _serviceRef;
    private ServiceDomain _domain;
    private ServerLocator _serverLocator;
    private ClientSessionFactory _factory;
    private ClientSession _session;
    private ClientConsumer _consumer;

    public InboundHandler(HornetQBindingModel hbm, ServerLocator serverLocator, ServiceDomain domain) {
        this._bindingModel = hbm;
        this._configModel = hbm.getHornetQConfig();
        this._messageComposer = HornetQComposition.getMessageComposer(hbm);
        this._domain = domain;
        this._serverLocator = serverLocator;
    }

    public void start() {
        this._serviceRef = this._domain.getServiceReference(this._bindingModel.getService().getQName());
        try {
            this._factory = this._serverLocator.createSessionFactory();
            this._session = this._configModel.isXASession() ? this._factory.createXASession() : this._factory.createSession();
            this._consumer = this._session.createConsumer(this._configModel.getQueue());
            this._consumer.setMessageHandler((MessageHandler)this);
            this._session.start();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void stop() {
        HornetQUtil.closeClientConsumer(this._consumer);
        HornetQUtil.closeSession(this._session);
        HornetQUtil.closeSessionFactory(this._factory);
        HornetQUtil.closeServerLocator(this._serverLocator);
    }

    public void onMessage(ClientMessage message) {
        Exchange exchange = this._serviceRef.createExchange(this.getOperationName(), (ExchangeHandler)this);
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this._applicationClassLoader);
            this._logger.info((Object)("onMessage :" + message));
            exchange.send(this._messageComposer.compose((Object)message, exchange, true));
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }

    private String getOperationName() {
        OperationSelector operationSelector = this._bindingModel.getOperationSelector();
        if (operationSelector != null) {
            return operationSelector.getOperationName();
        }
        return null;
    }
}

