/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.composer;

import org.hornetq.api.core.PropertyConversionException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseContextMapper;

public class HornetQContextMapper
extends BaseContextMapper<ClientMessage> {
    public void mapFrom(ClientMessage source, Context context) throws Exception {
        for (SimpleString key : source.getPropertyNames()) {
            Object value;
            String name = key.toString();
            if (!this.matches(name) || (value = source.getObjectProperty(key)) == null) continue;
            context.setProperty(name, value, Scope.EXCHANGE).addLabels(new String[]{"hornetq_message_property"});
        }
    }

    public void mapTo(Context context, ClientMessage target) throws Exception {
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            Object value;
            String name = property.getName();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            try {
                target.putObjectProperty(name, value);
            }
            catch (PropertyConversionException pce) {
                pce.getMessage();
            }
        }
    }
}

