/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.deploy;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ServerLocator;
import org.switchyard.component.hornetq.ServerLocatorBuilder;
import org.switchyard.component.hornetq.config.model.HornetQBindingModel;
import org.switchyard.component.hornetq.config.model.HornetQConfigModel;
import org.switchyard.component.hornetq.config.model.HornetQConnectorConfigModel;
import org.switchyard.component.hornetq.config.model.HornetQDiscoveryGroupConfigModel;
import org.switchyard.component.hornetq.deploy.InboundHandler;
import org.switchyard.component.hornetq.deploy.OutboundHandler;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.domain.PropertiesModel;
import org.switchyard.config.model.domain.PropertyModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;

public class HornetQActivator
extends BaseActivator {
    public HornetQActivator() {
        super(new String[]{"hornetq"});
    }

    public ServiceHandler activateBinding(QName name, BindingModel config) {
        if (config.isServiceBinding()) {
            return this.handleServiceBinding((HornetQBindingModel)config, name);
        }
        return this.handleReferenceBinding((HornetQBindingModel)config, name);
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    private ServiceHandler handleServiceBinding(HornetQBindingModel hbm, QName serviceName) {
        ServerLocator serverLocator = this.buildServerLocator(hbm.getHornetQConfig());
        return new InboundHandler(hbm, serverLocator, this.getServiceDomain());
    }

    private ServiceHandler handleReferenceBinding(HornetQBindingModel hbm, QName serviceName) {
        ServerLocator serverLocator = this.buildServerLocator(hbm.getHornetQConfig());
        return new OutboundHandler(hbm, serverLocator);
    }

    private ServerLocator buildServerLocator(HornetQConfigModel configModel) {
        ServerLocatorBuilder slb = new ServerLocatorBuilder();
        slb.ackBatchSize(configModel.getAckBatchSize());
        slb.autoGroup(configModel.isAutoGroup());
        slb.blockOnAcknowledge(configModel.isBlockOnAcknowledge());
        slb.blockOnDurableSend(configModel.isBlockOnDurableSend());
        slb.blockOnNonDurableSend(configModel.isBlockOnNonDurableSend());
        slb.cacheLargeMessagesOnConsumers(configModel.isCacheLargeMessagesClient());
        slb.callTimeout(configModel.getCallTimeout());
        slb.clientFailureCheckPeriod(configModel.getClientFailureCheckPeriod());
        slb.compressLargeMessage(configModel.isCompressLargeMessage());
        slb.confirmationWindowSize(configModel.getConfirmationWindowSize());
        slb.connectionLoadBalancingPolicyClassName(configModel.getConnectionLoadBalancingPolicyClassName());
        slb.connectionTTL(configModel.getConnectionTTL());
        slb.consumerMaxRate(configModel.getConsumerMaxRate());
        slb.consumerWindowSize(configModel.getConsumerWindowSize());
        slb.disableFinalizedCheck(configModel.isDisableFinalizeCheck());
        slb.discoveryGroupConfiguration(this.getDiscoveryGroupConfiguration(configModel.getDiscoveryGroup()));
        slb.failoverOnInitialConnection(configModel.isFailoverOnInitialConnection());
        slb.groupID(configModel.getGroupID());
        slb.initialMessagePacketSize(configModel.getInitialMessagePacketSize());
        slb.initialReconnectAttempts(configModel.getInitialConnectAttempts());
        slb.maxRetryInterval(configModel.getMaxRetryInterval());
        slb.minLargeMessageSize(configModel.getMinLargeMessageSize());
        slb.preAcknowledge(configModel.isPreAcknowledge());
        slb.producerMaxRate(configModel.getProducerMaxRate());
        slb.producerWindowSize(configModel.getProducerWindowSize());
        slb.reconnectAttempts(configModel.getReconnectAttempts());
        slb.retryInterval(configModel.getRetryInterval());
        slb.retryIntervalMultiplier(configModel.getRetryIntervalMultiplier());
        slb.scheduledThreadPoolMaxSize(configModel.getScheduledThreadPoolMaxSize());
        slb.threadPoolMaxSize(configModel.getThreadPoolMaxSize());
        slb.transportConfigurations(this.getTransportConfiguration(configModel.getConnectorConfiguration()));
        slb.useGlobalPools(configModel.isUseGlobalPools());
        slb.useHA(configModel.isUseHA());
        return slb.build();
    }

    private TransportConfiguration getTransportConfiguration(HornetQConnectorConfigModel config) {
        if (config == null) {
            return null;
        }
        PropertiesModel propertiesModel = config.getProperties();
        HashMap<String, String> connectorProperties = new HashMap<String, String>();
        if (propertiesModel != null) {
            for (PropertyModel propertyModel : propertiesModel.getProperties()) {
                connectorProperties.put(propertyModel.getName(), propertyModel.getValue());
            }
        }
        return new TransportConfiguration(config.getConnectorClassName(), connectorProperties);
    }

    private DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(HornetQDiscoveryGroupConfigModel config) {
        Long initialWaitTimeout;
        Long refreshTimeout;
        if (config == null) {
            return null;
        }
        DiscoveryGroupConfiguration discoveryGroupConfiguration = new DiscoveryGroupConfiguration(config.getGroupAddress(), config.getGroupPort().intValue());
        String localBindAddress = config.getLocalBindAddress();
        if (localBindAddress != null) {
            discoveryGroupConfiguration.setLocalBindAdress(localBindAddress);
        }
        if ((refreshTimeout = config.getRefreshTimeout()) != null) {
            discoveryGroupConfiguration.setRefreshTimeout(refreshTimeout.longValue());
        }
        if ((initialWaitTimeout = config.getInitialWaitTimeout()) != null) {
            discoveryGroupConfiguration.setDiscoveryInitialWaitTimeout(initialWaitTimeout.longValue());
        }
        return discoveryGroupConfiguration;
    }
}

