/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.hornetq.composer;

import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.hornetq.composer.HornetQBindingData;
import org.switchyard.component.hornetq.internal.HornetQUtil;

public class HornetQMessageComposer
extends BaseMessageComposer<HornetQBindingData> {
    public Message compose(HornetQBindingData source, Exchange exchange, boolean create) throws Exception {
        Message message = create ? exchange.createMessage() : exchange.getMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext());
        message.setContent((Object)HornetQUtil.readBytes(source.getClientMessage()));
        return message;
    }

    public HornetQBindingData decompose(Exchange exchange, HornetQBindingData target) throws Exception {
        this.getContextMapper().mapTo(exchange.getContext(), (BindingData)target);
        byte[] content = (byte[])exchange.getMessage().getContent(byte[].class);
        target.getClientMessage().getBodyBuffer().writeBytes(content);
        return target;
    }
}

