/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.http.ContentType;
import org.switchyard.component.http.HttpConsumeException;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpComposition;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.component.http.config.model.HttpBindingModel;
import org.switchyard.deploy.BaseServiceHandler;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private static final String HTTP_GET = "GET";
    private static final String HTTP_POST = "POST";
    private static final String HTTP_DELETE = "DELETE";
    private static final String HTTP_HEAD = "HEAD";
    private static final String HTTP_PUT = "PUT";
    private static final String HTTP_OPTIONS = "OPTIONS";
    private final HttpBindingModel _config;
    private MessageComposer<HttpBindingData> _messageComposer;
    private String _baseAddress = "http://localhost:8080";
    private String _httpMethod = "GET";
    private String _contentType;

    public OutboundHandler(HttpBindingModel config) {
        this._config = config;
    }

    public void start() throws HttpConsumeException {
        String contentType;
        String method;
        String address = this._config.getAddress();
        if (address != null) {
            this._baseAddress = address;
        }
        if ((method = this._config.getMethod()) != null) {
            this._httpMethod = method;
        }
        if ((contentType = this._config.getContentType()) != null) {
            this._contentType = contentType;
        }
        this._messageComposer = HttpComposition.getMessageComposer(this._config);
    }

    public void stop() {
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            Header[] headers;
            HttpBindingData httpRequest = (HttpBindingData)this._messageComposer.decompose(exchange, (BindingData)new HttpRequestBindingData());
            HttpGet request = null;
            if (this._httpMethod.equals(HTTP_GET)) {
                request = new HttpGet(this._baseAddress);
            } else if (this._httpMethod.equals(HTTP_POST)) {
                request = new HttpPost(this._baseAddress);
                ((HttpPost)request).setEntity((HttpEntity)new InputStreamEntity((InputStream)httpRequest.getBodyBytes(), (long)httpRequest.getBodyBytes().available()));
            } else if (this._httpMethod.equals(HTTP_DELETE)) {
                request = new HttpDelete(this._baseAddress);
            } else if (this._httpMethod.equals(HTTP_HEAD)) {
                request = new HttpHead(this._baseAddress);
            } else if (this._httpMethod.equals(HTTP_PUT)) {
                request = new HttpPut(this._baseAddress);
                ((HttpPut)request).setEntity((HttpEntity)new InputStreamEntity((InputStream)httpRequest.getBodyBytes(), (long)httpRequest.getBodyBytes().available()));
            } else if (this._httpMethod.equals(HTTP_OPTIONS)) {
                request = new HttpOptions(this._baseAddress);
            }
            for (Map.Entry<String, List<String>> entry : httpRequest.getHeaders().entrySet()) {
                String name = entry.getKey();
                List<String> values = entry.getValue();
                for (String value : values) {
                    request.addHeader(name, value);
                }
            }
            if (this._contentType != null) {
                request.addHeader("Content-Type", this._contentType);
            }
            HttpResponse response = httpclient.execute((HttpUriRequest)request);
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            HttpResponseBindingData httpResponse = new HttpResponseBindingData();
            for (Header header : headers = response.getAllHeaders()) {
                httpResponse.addHeader(header.getName(), header.getValue());
            }
            if (entity != null) {
                if (entity.getContentType() != null) {
                    httpResponse.setContentType(new ContentType(entity.getContentType().getValue()));
                } else {
                    httpResponse.setContentType(new ContentType());
                }
                httpResponse.setBodyFromStream(entity.getContent());
            }
            httpResponse.setStatus(status);
            Message out = this._messageComposer.compose((BindingData)httpResponse, exchange, true);
            if (httpResponse.getStatus() < 400) {
                exchange.send(out);
            } else {
                exchange.sendFault(out);
            }
        }
        catch (Exception e) {
            throw new HandlerException("Unexpected exception handling HTTP Message", (Throwable)e);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }
}

