/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http.composer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.http.ContentType;

public abstract class HttpBindingData
implements BindingData {
    private Map<String, List<String>> _headers;
    private byte[] _body;
    private ContentType _contentType;
    private ByteArrayInputStream _content;
    private long _contentLength;

    public Map<String, List<String>> getHeaders() {
        if (this._headers == null) {
            this._headers = new HashMap<String, List<String>>();
        }
        return this._headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this._headers = headers;
    }

    public void addHeader(String name, List<String> values) {
        if (this._headers == null) {
            this._headers = new HashMap<String, List<String>>();
        }
        this._headers.put(name, values);
    }

    public void addHeader(String name, String value) {
        List<String> values;
        if (this._headers == null) {
            this._headers = new HashMap<String, List<String>>();
        }
        if ((values = this._headers.get(name)) == null) {
            values = new ArrayList<String>();
            this._headers.put(name, values);
        }
        values.add(value);
    }

    public StringReader getBody() throws UnsupportedEncodingException {
        String body = null;
        body = this._contentType != null && this._contentType.getCharset() != null ? new String(this._body, this._contentType.getCharset()) : new String(this._body);
        return new StringReader(body);
    }

    public String getBodyAsString() throws UnsupportedEncodingException {
        String body = null;
        body = this._contentType != null && this._contentType.getCharset() != null ? new String(this._body, this._contentType.getCharset()) : new String(this._body);
        return body;
    }

    public ByteArrayInputStream getBodyBytes() {
        if (this._body != null) {
            return new ByteArrayInputStream(this._body);
        }
        return null;
    }

    public void setBodyFromStream(InputStream is) throws IOException {
        if (is != null) {
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            byte[] buff = new byte[512];
            int buffSize = 0;
            while ((buffSize = is.read(buff)) >= 0) {
                tmp.write(buff, 0, buffSize);
            }
            this._body = tmp.toByteArray();
            is.close();
        } else {
            this._body = null;
        }
    }

    public void setBodyFromReader(Reader reader) throws IOException {
        if (reader != null) {
            StringWriter tmp = new StringWriter();
            char[] buff = new char[512];
            int buffSize = 0;
            while ((buffSize = reader.read(buff)) >= 0) {
                tmp.write(buff, 0, buffSize);
            }
            this._body = tmp.toString().getBytes();
            reader.close();
        } else {
            this._body = null;
        }
    }

    public void writeBodyToStream(OutputStream os) throws IOException {
        if (os != null) {
            os.write(this._body);
            os.close();
        }
    }

    public void setBody(String body) {
        this._body = this._contentType != null ? body.getBytes(Charset.forName(this._contentType.getCharset())) : body.getBytes();
    }

    public void setBodyBytes(byte[] body) {
        this._body = (byte[])(body != null ? (byte[])body.clone() : null);
    }

    public ContentType getContentType() {
        return this._contentType;
    }

    public void setContentType(ContentType contentType) {
        this._contentType = contentType;
    }
}

