/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http.composer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;

public class HttpContextMapper
extends BaseRegexContextMapper<HttpBindingData> {
    public void mapFrom(HttpBindingData source, Context context) throws Exception {
        Iterator<Map.Entry<String, List<String>>> entries = source.getHeaders().entrySet().iterator();
        if (source instanceof HttpResponseBindingData) {
            HttpResponseBindingData response = (HttpResponseBindingData)source;
            context.setProperty("status", (Object)response.getStatus(), Scope.IN).addLabels(new String[]{"http_header"});
        } else {
            HttpRequestBindingData request = (HttpRequestBindingData)source;
            if (request.getRequestInfo() != null) {
                context.setProperty("request_info", (Object)request.getRequestInfo(), Scope.IN).addLabels(new String[]{"http_header"});
            }
        }
        while (entries.hasNext()) {
            Map.Entry<String, List<String>> entry = entries.next();
            String name = entry.getKey();
            if (!this.matches(name)) continue;
            List<String> values = entry.getValue();
            if (values != null && values.size() == 1) {
                context.setProperty(name, (Object)values.get(0), Scope.IN).addLabels(new String[]{"http_header"});
                continue;
            }
            if (values == null || values.size() <= 1) continue;
            context.setProperty(name, values, Scope.IN).addLabels(new String[]{"http_header"});
        }
    }

    public void mapTo(Context context, HttpBindingData target) throws Exception {
        Map<String, List<String>> httpHeaders = target.getHeaders();
        for (Property property : context.getProperties(Scope.OUT)) {
            if (!property.hasLabel("http_header")) continue;
            String name = property.getName();
            Object value = property.getValue();
            if ("status".equalsIgnoreCase(name) && target instanceof HttpResponseBindingData) {
                HttpResponseBindingData response = (HttpResponseBindingData)target;
                if (value instanceof String) {
                    response.setStatus(Integer.valueOf((String)value));
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                response.setStatus((Integer)value);
                continue;
            }
            if (!this.matches(name) || value == null) continue;
            if (value instanceof List) {
                httpHeaders.put(name, (List)value);
                continue;
            }
            if (!(value instanceof String)) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add(String.valueOf(value));
            httpHeaders.put(name, list);
        }
    }
}

