/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http.config.model;

import javax.xml.namespace.QName;
import org.switchyard.component.http.config.model.ValueModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.Configurations;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1BindingModel;

public class HttpBindingModel
extends V1BindingModel {
    public static final String HTTP = "http";
    public static final String DEFAULT_NAMESPACE = "urn:switchyard-component-http:config:1.0";
    private static final String ADDRESS = "address";
    private static final String CONTEXT_PATH = "contextPath";
    private static final String METHOD = "method";
    private static final String CONTENT_TYPE = "contentType";
    private QName _serviceName;
    private String _contextPath;
    private String _address;
    private String _method;
    private String _contentType;
    private Configuration _environment = Configurations.emptyConfig();

    public HttpBindingModel() {
        super(HTTP, DEFAULT_NAMESPACE);
        this.setModelChildrenOrder(new String[]{CONTEXT_PATH, ADDRESS, METHOD, CONTENT_TYPE});
    }

    public HttpBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder(new String[]{CONTEXT_PATH, ADDRESS, METHOD, CONTENT_TYPE});
    }

    public QName getServiceName() {
        if (this._serviceName == null) {
            this._serviceName = this.isServiceBinding() ? this.getService().getQName() : this.getReference().getQName();
        }
        return this._serviceName;
    }

    public void setServiceName(QName serviceName) {
        this._serviceName = serviceName;
    }

    public String getContextPath() {
        Configuration childConfig;
        if (this._contextPath == null && (childConfig = this.getModelConfiguration().getFirstChild(CONTEXT_PATH)) != null) {
            this._contextPath = childConfig.getValue();
        }
        return this._contextPath;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(CONTEXT_PATH);
        if (childConfig == null) {
            ValueModel contextPathConfig = new ValueModel(CONTEXT_PATH);
            contextPathConfig.setValue(contextPath);
            this.setChildModel((Model)contextPathConfig);
        } else {
            childConfig.setValue(contextPath);
        }
    }

    public String getAddress() {
        Configuration childConfig;
        if (this._address == null && (childConfig = this.getModelConfiguration().getFirstChild(ADDRESS)) != null) {
            this._address = childConfig.getValue();
        }
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(ADDRESS);
        if (childConfig == null) {
            ValueModel addressConfig = new ValueModel(ADDRESS);
            addressConfig.setValue(address);
            this.setChildModel((Model)addressConfig);
        } else {
            childConfig.setValue(address);
        }
    }

    public String getMethod() {
        Configuration childConfig;
        if (this._method == null && (childConfig = this.getModelConfiguration().getFirstChild(METHOD)) != null) {
            this._method = childConfig.getValue();
        }
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(METHOD);
        if (childConfig == null) {
            ValueModel methodConfig = new ValueModel(METHOD);
            methodConfig.setValue(method);
            this.setChildModel((Model)methodConfig);
        } else {
            childConfig.setValue(method);
        }
    }

    public String getContentType() {
        Configuration childConfig;
        if (this._contentType == null && (childConfig = this.getModelConfiguration().getFirstChild(CONTENT_TYPE)) != null) {
            this._contentType = childConfig.getValue();
        }
        return this._contentType;
    }

    public void setContentType(String contentType) {
        this._contentType = contentType;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(CONTENT_TYPE);
        if (childConfig == null) {
            ValueModel contentTypeConfig = new ValueModel(CONTENT_TYPE);
            contentTypeConfig.setValue(contentType);
            this.setChildModel((Model)contentTypeConfig);
        } else {
            childConfig.setValue(contentType);
        }
    }

    public void setEnvironment(Configuration config) {
        this._environment = config;
    }
}

