/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.switchyard.component.http.ContentType;
import org.switchyard.component.http.InboundHandler;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpRequestInfo;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.security.credential.extractor.ServletRequestCredentialExtractor;

public class HttpGatewayServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(HttpGatewayServlet.class);
    private static final Map<String, String> LOCALNAMEMAP = new ConcurrentHashMap<String, String>();
    private transient InboundHandler _handler;

    private static final String getLocalName(HttpServletRequest request) {
        String localAddr = request.getLocalAddr();
        String localName = LOCALNAMEMAP.get(localAddr);
        if (localName == null) {
            localName = request.getLocalName();
            LOCALNAMEMAP.put(localAddr, localName);
        }
        return localName;
    }

    public void setHandler(InboundHandler handler) {
        this._handler = handler;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handle(request, response);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpRequestBindingData httpRequest = new HttpRequestBindingData();
        try {
            httpRequest.setContentType(new ContentType(request.getContentType()));
            httpRequest.setBodyFromStream((InputStream)request.getInputStream());
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    httpRequest.addHeader(name, value);
                }
            }
            httpRequest.setRequestInfo(this.getRequestInfo(request));
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unexpected Exception while reading request", (Throwable)e);
        }
        HttpResponseBindingData httpResponse = this._handler.invoke(httpRequest);
        try {
            if (httpResponse != null) {
                for (Map.Entry<String, List<String>> entry : httpResponse.getHeaders().entrySet()) {
                    String name = entry.getKey();
                    List<String> values = entry.getValue();
                    for (String value : values) {
                        response.setHeader(name, value);
                    }
                }
                if (httpResponse.getBodyBytes() != null) {
                    response.setStatus(httpResponse.getStatus().intValue());
                    httpResponse.writeBodyToStream((OutputStream)response.getOutputStream());
                } else {
                    response.setStatus(httpResponse.getStatus().intValue());
                }
            } else {
                response.setStatus(500);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Unexpected Exception while writing response", (Throwable)e);
        }
    }

    public HttpRequestInfo getRequestInfo(HttpServletRequest request) {
        Map paramMap;
        HttpRequestInfo requestInfo = new HttpRequestInfo();
        requestInfo.setAuthType(request.getAuthType());
        requestInfo.setCharacterEncoding(request.getCharacterEncoding());
        requestInfo.setContentType(request.getContentType());
        requestInfo.setContextPath(request.getContextPath());
        requestInfo.setLocalAddr(request.getLocalAddr());
        requestInfo.setLocalName(HttpGatewayServlet.getLocalName(request));
        requestInfo.setMethod(request.getMethod());
        requestInfo.setProtocol(request.getProtocol());
        requestInfo.setQueryString(request.getQueryString());
        requestInfo.setRemoteAddr(request.getRemoteAddr());
        requestInfo.setRemoteHost(request.getRemoteHost());
        requestInfo.setRemoteUser(request.getRemoteUser());
        requestInfo.setContentLength(request.getContentLength());
        requestInfo.setRequestSessionId(request.getRequestedSessionId());
        requestInfo.setRequestURI(request.getRequestURI());
        requestInfo.setScheme(request.getScheme());
        requestInfo.setServerName(request.getServerName());
        requestInfo.setRequestPath(request.getServletPath());
        String pathInfo = request.getPathInfo();
        requestInfo.setPathInfo(pathInfo);
        if (pathInfo != null) {
            List<String> pathInfoTokens = requestInfo.getPathInfoTokens();
            pathInfoTokens.addAll(Arrays.asList(request.getPathInfo().split("/")));
            Iterator<String> tokensIterator = pathInfoTokens.iterator();
            while (tokensIterator.hasNext()) {
                if (tokensIterator.next().trim().length() != 0) continue;
                tokensIterator.remove();
            }
        }
        if ((paramMap = request.getParameterMap()) != null) {
            requestInfo.getQueryParams().putAll(paramMap);
        }
        requestInfo.getCredentials().addAll(new ServletRequestCredentialExtractor().extract((ServletRequest)request));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)requestInfo);
        }
        return requestInfo;
    }
}

