/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http;

import java.util.Set;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.common.selector.OperationSelectorFactory;
import org.switchyard.component.http.HttpPublishException;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpComposition;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.component.http.config.model.HttpBindingModel;
import org.switchyard.component.http.endpoint.Endpoint;
import org.switchyard.component.http.endpoint.EndpointPublisherFactory;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.security.SecurityContext;
import org.switchyard.selector.OperationSelector;

public class InboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(InboundHandler.class);
    private final HttpBindingModel _config;
    private ServiceDomain _domain;
    private ServiceReference _serviceRef;
    private MessageComposer<HttpBindingData> _messageComposer;
    private final OperationSelector<HttpBindingData> _operationSelector;
    private Endpoint _endpoint;

    public InboundHandler(HttpBindingModel config, ServiceDomain domain) {
        this._config = config;
        this._domain = domain;
        this._operationSelector = OperationSelectorFactory.getOperationSelectorFactory(HttpBindingData.class).newOperationSelector(config.getOperationSelector());
    }

    public void start() throws HttpPublishException {
        try {
            this._serviceRef = this._domain.getServiceReference(this._config.getServiceName());
            String contextPath = this._config.getContextPath();
            if (contextPath == null) {
                contextPath = "/";
            }
            this._endpoint = EndpointPublisherFactory.getPublisher().publish(contextPath, this);
            this._messageComposer = HttpComposition.getMessageComposer(this._config);
        }
        catch (Exception e) {
            throw new HttpPublishException(e);
        }
    }

    public HttpResponseBindingData invoke(HttpRequestBindingData input) {
        HttpResponseBindingData response = null;
        try {
            SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
            Exchange exchange = this._serviceRef.createExchange(this.getOperationName(input), (ExchangeHandler)inOutHandler);
            Message message = this._messageComposer.compose((BindingData)input, exchange);
            SecurityContext.get((Exchange)exchange).getCredentials().addAll(input.extractCredentials());
            if (exchange.getContract().getConsumerOperation().getExchangePattern() == ExchangePattern.IN_ONLY) {
                exchange.send(message);
                response = new HttpResponseBindingData();
            } else {
                exchange.send(message);
                exchange = inOutHandler.waitForOut();
                response = (HttpResponseBindingData)this._messageComposer.decompose(exchange, (BindingData)new HttpResponseBindingData());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return response;
    }

    public void stop() {
        this._endpoint.stop();
    }

    public void handleFault(Exchange exchange) {
        throw new IllegalStateException("Unexpected");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw new IllegalStateException("Unexpected");
    }

    private String getOperationName(HttpRequestBindingData message) throws Exception {
        String operationName = null;
        if (this._operationSelector != null) {
            operationName = this._operationSelector.selectOperation((Object)message).getLocalPart();
        }
        if (operationName == null) {
            Set operations = this._serviceRef.getInterface().getOperations();
            if (operations.size() != 1) {
                StringBuilder msg = new StringBuilder();
                msg.append("No operationSelector was configured for the Http Component and the Service Interface ");
                msg.append("contains more than one operation: ").append(operations);
                msg.append("Please add an operationSelector element.");
                throw new SwitchYardException(msg.toString());
            }
            ServiceOperation serviceOperation = (ServiceOperation)operations.iterator().next();
            operationName = serviceOperation.getName();
        }
        return operationName;
    }
}

