/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.http.ContentType;
import org.switchyard.component.http.HttpConsumeException;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpComposition;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.component.http.config.model.HttpBindingModel;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.label.BehaviorLabel;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private static final String HTTP_GET = "GET";
    private static final String HTTP_POST = "POST";
    private static final String HTTP_DELETE = "DELETE";
    private static final String HTTP_HEAD = "HEAD";
    private static final String HTTP_PUT = "PUT";
    private static final String HTTP_OPTIONS = "OPTIONS";
    private final HttpBindingModel _config;
    private final String _bindingName;
    private final String _referenceName;
    private MessageComposer<HttpBindingData> _messageComposer;
    private String _baseAddress = "http://localhost:8080";
    private String _httpMethod = "GET";
    private String _contentType;
    private AuthScope _authScope;
    private AuthCache _authCache;
    private Credentials _credentials;
    private HttpHost _proxyHost;

    public OutboundHandler(HttpBindingModel config, ServiceDomain domain) {
        super(domain);
        this._config = config;
        this._bindingName = config.getName();
        this._referenceName = config.getReference().getName();
    }

    protected void doStart() throws HttpConsumeException {
        String contentType;
        String method;
        String address = this._config.getAddress();
        if (address != null) {
            this._baseAddress = address;
        }
        if ((method = this._config.getMethod()) != null) {
            this._httpMethod = method;
        }
        if ((contentType = this._config.getContentType()) != null) {
            this._contentType = contentType;
        }
        this._messageComposer = HttpComposition.getMessageComposer(this._config);
        if (this._config.hasAuthentication().booleanValue()) {
            if (this._config.isBasicAuth().booleanValue()) {
                this._authScope = this.createAuthScope(this._config.getBasicAuthConfig().getHost(), this._config.getBasicAuthConfig().getPort(), this._config.getBasicAuthConfig().getRealm());
                this._credentials = new UsernamePasswordCredentials(this._config.getBasicAuthConfig().getUser(), this._config.getBasicAuthConfig().getPassword());
                this._authCache = new BasicAuthCache();
                this._authCache.put(new HttpHost(this._authScope.getHost(), this._authScope.getPort()), (AuthScheme)new BasicScheme(ChallengeState.TARGET));
            } else {
                this._authScope = this.createAuthScope(this._config.getNtlmAuthConfig().getHost(), this._config.getNtlmAuthConfig().getPort(), this._config.getNtlmAuthConfig().getRealm());
                this._credentials = new NTCredentials(this._config.getNtlmAuthConfig().getUser(), this._config.getNtlmAuthConfig().getPassword(), "", this._config.getNtlmAuthConfig().getDomain());
            }
        }
        if (this._config.getProxyConfig() != null) {
            this._proxyHost = this._config.getProxyConfig().getPort() != null ? new HttpHost(this._config.getProxyConfig().getHost(), Integer.valueOf(this._config.getProxyConfig().getPort()).intValue()) : new HttpHost(this._config.getProxyConfig().getHost(), -1);
            if (this._config.getProxyConfig().getUser() != null) {
                this._authScope = this.createAuthScope(this._config.getProxyConfig().getHost(), this._config.getProxyConfig().getPort(), null);
                this._credentials = new UsernamePasswordCredentials(this._config.getProxyConfig().getUser(), this._config.getProxyConfig().getPassword());
                if (this._authCache == null) {
                    this._authCache = new BasicAuthCache();
                }
                this._authCache.put(this._proxyHost, (AuthScheme)new BasicScheme(ChallengeState.PROXY));
            }
        }
    }

    private AuthScope createAuthScope(String host, String portStr, String realm) throws HttpConsumeException {
        URL url = null;
        try {
            url = new URL(this._baseAddress);
        }
        catch (MalformedURLException mue) {
            throw new HttpConsumeException(mue);
        }
        if (realm == null) {
            realm = AuthScope.ANY_REALM;
        }
        int port = url.getPort();
        if (host == null) {
            host = url.getHost();
        }
        if (portStr != null) {
            port = Integer.valueOf(portStr);
        }
        return new AuthScope(host, port, realm);
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._bindingName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        if (this.getState() != Lifecycle.State.STARTED) {
            throw new HandlerException(String.format("Reference binding \"%s/%s\" is not started.", this._referenceName, this._bindingName));
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            Header[] headers;
            if (this._credentials != null) {
                httpclient.getCredentialsProvider().setCredentials(this._authScope, this._credentials);
                ArrayList<String> authpref = new ArrayList<String>();
                authpref.add("NTLM");
                authpref.add("Basic");
                httpclient.getParams().setParameter("http.auth.target-scheme-pref", authpref);
            }
            if (this._proxyHost != null) {
                httpclient.getParams().setParameter("http.route.default-proxy", (Object)this._proxyHost);
            }
            HttpBindingData httpRequest = (HttpBindingData)this._messageComposer.decompose(exchange, (BindingData)new HttpRequestBindingData());
            HttpGet request = null;
            if (this._httpMethod.equals(HTTP_GET)) {
                request = new HttpGet(this._baseAddress);
            } else if (this._httpMethod.equals(HTTP_POST)) {
                request = new HttpPost(this._baseAddress);
                ((HttpPost)request).setEntity((HttpEntity)new InputStreamEntity((InputStream)httpRequest.getBodyBytes(), (long)httpRequest.getBodyBytes().available()));
            } else if (this._httpMethod.equals(HTTP_DELETE)) {
                request = new HttpDelete(this._baseAddress);
            } else if (this._httpMethod.equals(HTTP_HEAD)) {
                request = new HttpHead(this._baseAddress);
            } else if (this._httpMethod.equals(HTTP_PUT)) {
                request = new HttpPut(this._baseAddress);
                ((HttpPut)request).setEntity((HttpEntity)new InputStreamEntity((InputStream)httpRequest.getBodyBytes(), (long)httpRequest.getBodyBytes().available()));
            } else if (this._httpMethod.equals(HTTP_OPTIONS)) {
                request = new HttpOptions(this._baseAddress);
            }
            for (Map.Entry<String, List<String>> entry : httpRequest.getHeaders().entrySet()) {
                String name = entry.getKey();
                List<String> values = entry.getValue();
                for (String value : values) {
                    request.addHeader(name, value);
                }
            }
            if (this._contentType != null) {
                request.addHeader("Content-Type", this._contentType);
            }
            HttpResponse response = null;
            if (this._credentials != null && this._credentials instanceof NTCredentials) {
                response = httpclient.execute((HttpUriRequest)new HttpGet(this._baseAddress));
                HttpClientUtils.closeQuietly((HttpResponse)response);
            }
            if (this._authCache != null) {
                BasicHttpContext context = new BasicHttpContext();
                context.setAttribute("http.auth.auth-cache", (Object)this._authCache);
                response = httpclient.execute((HttpUriRequest)request, (HttpContext)context);
            } else {
                response = httpclient.execute((HttpUriRequest)request);
            }
            int status = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            HttpResponseBindingData httpResponse = new HttpResponseBindingData();
            for (Header header : headers = response.getAllHeaders()) {
                httpResponse.addHeader(header.getName(), header.getValue());
            }
            if (entity != null) {
                if (entity.getContentType() != null) {
                    httpResponse.setContentType(new ContentType(entity.getContentType().getValue()));
                } else {
                    httpResponse.setContentType(new ContentType());
                }
                httpResponse.setBodyFromStream(entity.getContent());
            }
            httpResponse.setStatus(status);
            Message out = this._messageComposer.compose((BindingData)httpResponse, exchange);
            if (httpResponse.getStatus() < 400) {
                exchange.send(out);
            } else {
                exchange.sendFault(out);
            }
        }
        catch (Exception e) {
            throw new HandlerException("Unexpected exception handling HTTP Message", (Throwable)e);
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }
}

