/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http.composer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.config.model.composer.MessageComposerModel;

public class HttpMessageComposer
extends BaseMessageComposer<HttpBindingData> {
    private MessageComposerModel _config;

    public Message compose(HttpBindingData source, Exchange exchange) throws Exception {
        Message message = exchange.createMessage();
        this.getContextMapper().mapFrom((BindingData)source, exchange.getContext(message));
        message.setContent((Object)source.getBody());
        return message;
    }

    public HttpBindingData decompose(Exchange exchange, HttpBindingData target) throws Exception {
        Message message = exchange.getMessage();
        if (message != null) {
            Property responseCode;
            Object content = message.getContent();
            if (target instanceof HttpResponseBindingData && ((responseCode = exchange.getContext().getProperty("http_response_status")) == null || !responseCode.hasLabel(EndpointLabel.HTTP.label()))) {
                int status = 202;
                status = content == null ? 204 : (content instanceof HttpResponseBindingData ? ((HttpResponseBindingData)content).getStatus() : (content instanceof String || content instanceof byte[] || content instanceof InputStream || content instanceof Reader ? 200 : 502));
                HttpResponseBindingData response = (HttpResponseBindingData)target;
                response.setStatus(status);
            }
            this.setContent(content, target);
        }
        this.getContextMapper().mapTo(exchange.getContext(), (BindingData)target);
        return target;
    }

    private void setContent(Object content, HttpBindingData message) throws IOException {
        if (content == null) {
            message.setBodyBytes(null);
        } else if (content instanceof String) {
            message.setBody((String)content);
        } else if (content instanceof byte[]) {
            message.setBodyBytes((byte[])content);
        } else if (content instanceof InputStream) {
            message.setBodyFromStream((InputStream)content);
        } else if (content instanceof Reader) {
            message.setBodyFromReader((Reader)content);
        } else {
            message.setBody("" + content);
        }
    }

    public MessageComposerModel getComposerConfig() {
        return this._config;
    }

    public void setComposerConfig(MessageComposerModel composerConfig) {
        this._config = composerConfig;
    }
}

