/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http;

import java.util.Set;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.common.selector.OperationSelectorFactory;
import org.switchyard.component.http.HttpLogger;
import org.switchyard.component.http.HttpMessages;
import org.switchyard.component.http.HttpPublishException;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpComposition;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.component.http.config.model.HttpBindingModel;
import org.switchyard.component.http.endpoint.Endpoint;
import org.switchyard.component.http.endpoint.EndpointPublisherFactory;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.security.context.SecurityContextManager;
import org.switchyard.selector.OperationSelector;

public class InboundHandler
extends BaseServiceHandler {
    private final HttpBindingModel _config;
    private final String _gatewayName;
    private SecurityContextManager _securityContextManager;
    private ServiceDomain _domain;
    private ServiceReference _serviceRef;
    private MessageComposer<HttpBindingData> _messageComposer;
    private final OperationSelector<HttpBindingData> _operationSelector;
    private Endpoint _endpoint;

    public InboundHandler(HttpBindingModel config, ServiceDomain domain) {
        super(domain);
        this._config = config;
        this._gatewayName = config.getName();
        this._domain = domain;
        this._securityContextManager = new SecurityContextManager(this._domain);
        this._operationSelector = OperationSelectorFactory.getOperationSelectorFactory(HttpBindingData.class).newOperationSelector(config.getOperationSelector());
    }

    protected void doStart() throws HttpPublishException {
        try {
            this._serviceRef = this._domain.getServiceReference(this._config.getServiceName());
            String contextPath = this._config.getContextPath();
            if (contextPath == null) {
                contextPath = "/";
            }
            this._endpoint = EndpointPublisherFactory.getPublisher().publish(contextPath, this);
            this._messageComposer = HttpComposition.getMessageComposer(this._config);
        }
        catch (Exception e) {
            throw HttpMessages.MESSAGES.unableToPublish(e);
        }
    }

    public HttpResponseBindingData invoke(HttpRequestBindingData input) {
        HttpResponseBindingData response = null;
        try {
            SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
            Exchange exchange = this._serviceRef.createExchange(this.getOperationName(input), (ExchangeHandler)inOutHandler);
            exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._gatewayName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
            Message message = this._messageComposer.compose((BindingData)input, exchange);
            this._securityContextManager.addCredentials(exchange, input.extractCredentials());
            if (exchange.getContract().getConsumerOperation().getExchangePattern() == ExchangePattern.IN_ONLY) {
                exchange.send(message);
                response = new HttpResponseBindingData();
            } else {
                exchange.send(message);
                exchange = inOutHandler.waitForOut();
                response = (HttpResponseBindingData)this._messageComposer.decompose(exchange, (BindingData)new HttpResponseBindingData());
            }
        }
        catch (Exception e) {
            HttpLogger.ROOT_LOGGER.unexpectedExceptionInvokingSwitchyardServcie(e);
        }
        return response;
    }

    protected void doStop() {
        this._endpoint.stop();
    }

    public void handleFault(Exchange exchange) {
        throw HttpMessages.MESSAGES.unexpectedFault();
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw HttpMessages.MESSAGES.unexpectedMessage();
    }

    private String getOperationName(HttpRequestBindingData message) throws Exception {
        String operationName = null;
        if (this._operationSelector != null) {
            operationName = this._operationSelector.selectOperation((Object)message).getLocalPart();
        }
        if (operationName == null) {
            Set operations = this._serviceRef.getInterface().getOperations();
            if (operations.size() != 1) {
                throw HttpMessages.MESSAGES.moreThanOneOperationSelector(operations);
            }
            ServiceOperation serviceOperation = (ServiceOperation)operations.iterator().next();
            operationName = serviceOperation.getName();
        }
        return operationName;
    }
}

