/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http.endpoint;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.com.sun.net.httpserver.BasicAuthenticator;
import org.jboss.com.sun.net.httpserver.HttpContext;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.logging.Logger;
import org.switchyard.component.http.ContentType;
import org.switchyard.component.http.HttpLogger;
import org.switchyard.component.http.InboundHandler;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpRequestInfo;
import org.switchyard.component.http.composer.HttpResponseBindingData;
import org.switchyard.component.http.endpoint.Endpoint;
import org.switchyard.component.http.endpoint.EndpointPublisher;
import org.switchyard.component.http.endpoint.StandaloneEndpoint;
import org.switchyard.security.jboss.credential.extractor.HttpExchangeCredentialExtractor;

public class StandaloneEndpointPublisher
implements EndpointPublisher {
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_PORT_PROPERTY = "org.switchyard.component.http.standalone.port";
    private static final Logger LOGGER = Logger.getLogger(StandaloneEndpointPublisher.class);
    private static final String CONTENT_TYPE = "Content-Type";
    private static HttpServer _httpServer;

    @Override
    public Endpoint publish(String context, InboundHandler handler) throws Exception {
        HttpContext httpContext = null;
        if (!context.startsWith("/")) {
            context = "/" + context;
        }
        if (_httpServer != null) {
            httpContext = _httpServer.createContext(context, (HttpHandler)new StandaloneHandler(handler));
        }
        return new StandaloneEndpoint(httpContext);
    }

    public static HttpRequestInfo getRequestInfo(HttpExchange request, ContentType type) throws IOException {
        HttpRequestInfo requestInfo = new HttpRequestInfo();
        if (request.getHttpContext().getAuthenticator() instanceof BasicAuthenticator) {
            requestInfo.setAuthType("BASIC");
        }
        URI u = request.getRequestURI();
        URI requestURI = null;
        try {
            requestURI = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            LOGGER.debug((Object)e);
        }
        requestInfo.setCharacterEncoding(type.getCharset());
        requestInfo.setContentType(type.toString());
        requestInfo.setContextPath(request.getHttpContext().getPath());
        requestInfo.setLocalAddr(request.getLocalAddress().getAddress().getHostAddress());
        requestInfo.setLocalName(request.getLocalAddress().getAddress().getHostName());
        requestInfo.setMethod(request.getRequestMethod());
        requestInfo.setProtocol(request.getProtocol());
        requestInfo.setQueryString(u.getQuery());
        requestInfo.setRemoteAddr(request.getRemoteAddress().getAddress().getHostAddress());
        requestInfo.setRemoteHost(request.getRemoteAddress().getAddress().getHostName());
        if (request.getHttpContext().getAuthenticator() instanceof BasicAuthenticator) {
            requestInfo.setRemoteUser(request.getPrincipal().getUsername());
        }
        requestInfo.setContentLength(request.getRequestBody().available());
        if (requestURI != null) {
            requestInfo.setRequestURI(requestURI.toString());
        }
        requestInfo.setScheme(u.getScheme());
        requestInfo.setServerName(u.getHost());
        requestInfo.setRequestPath(u.getPath());
        if (requestInfo.getQueryString() != null) {
            StringTokenizer params = new StringTokenizer(requestInfo.getQueryString(), "&");
            while (params.hasMoreTokens()) {
                String param = params.nextToken();
                String[] nameValue = param.split("=");
                requestInfo.addQueryParam(nameValue[0], nameValue[1]);
            }
        }
        requestInfo.getCredentials().addAll(new HttpExchangeCredentialExtractor().extract(request));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)requestInfo);
        }
        return requestInfo;
    }

    static int getPort() {
        int port = 8080;
        String portAsStr = System.getProperty(DEFAULT_PORT_PROPERTY);
        if (portAsStr != null) {
            port = Integer.parseInt(portAsStr);
        }
        return port;
    }

    static {
        try {
            _httpServer = HttpServer.create((InetSocketAddress)new InetSocketAddress(StandaloneEndpointPublisher.getPort()), (int)10);
            _httpServer.setExecutor(null);
            _httpServer.start();
        }
        catch (IOException ioe) {
            HttpLogger.ROOT_LOGGER.unableToLaunchStandaloneHttpServer(ioe);
        }
    }

    private static class StandaloneHandler
    implements HttpHandler {
        private InboundHandler _handler;

        public StandaloneHandler(InboundHandler handler) {
            this._handler = handler;
        }

        public void handle(HttpExchange exchange) {
            block11: {
                try {
                    HttpRequestBindingData httpRequest = new HttpRequestBindingData();
                    Object responseBody = null;
                    try {
                        String contentTypeStr = exchange.getRequestHeaders().getFirst(StandaloneEndpointPublisher.CONTENT_TYPE);
                        ContentType contentType = new ContentType(contentTypeStr);
                        httpRequest.setContentType(contentType);
                        httpRequest.setBodyFromStream(exchange.getRequestBody());
                        httpRequest.setHeaders((Map<String, List<String>>)exchange.getRequestHeaders());
                        httpRequest.setRequestInfo(StandaloneEndpointPublisher.getRequestInfo(exchange, contentType));
                    }
                    catch (IOException e) {
                        HttpLogger.ROOT_LOGGER.unexpectedExceptionWhileReadingRequest(e);
                    }
                    HttpResponseBindingData httpResponse = this._handler.invoke(httpRequest);
                    try {
                        if (httpResponse != null) {
                            exchange.getResponseHeaders().putAll(httpResponse.getHeaders());
                            if (httpResponse.getBodyBytes() != null) {
                                exchange.sendResponseHeaders(httpResponse.getStatus().intValue(), (long)httpResponse.getBodyBytes().available());
                                httpResponse.writeBodyToStream(exchange.getResponseBody());
                            } else if (httpResponse != null && httpResponse.getStatus() != null) {
                                exchange.sendResponseHeaders(httpResponse.getStatus().intValue(), 0L);
                            } else {
                                exchange.sendResponseHeaders(202, 0L);
                            }
                            break block11;
                        }
                        exchange.sendResponseHeaders(500, 0L);
                    }
                    catch (IOException e) {
                        HttpLogger.ROOT_LOGGER.unexpectedExceptionWhileWritingResponse(e);
                    }
                }
                catch (Exception e) {
                    HttpLogger.ROOT_LOGGER.unexpectedExceptionWhileHandlingHttpRequest(e);
                }
            }
        }
    }
}

