/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.http.composer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.component.common.composer.BaseRegexContextMapper;
import org.switchyard.component.common.label.ComponentLabel;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.http.composer.HttpBindingData;
import org.switchyard.component.http.composer.HttpRequestBindingData;
import org.switchyard.component.http.composer.HttpResponseBindingData;

public class HttpContextMapper
extends BaseRegexContextMapper<HttpBindingData> {
    public static final String HTTP_RESPONSE_STATUS = "http_response_status";
    private static final String[] HTTP_LABELS = new String[]{ComponentLabel.HTTP.label(), EndpointLabel.HTTP.label()};

    public void mapFrom(HttpBindingData source, Context context) throws Exception {
        if (source instanceof HttpResponseBindingData) {
            HttpResponseBindingData response = (HttpResponseBindingData)source;
            context.setProperty(HTTP_RESPONSE_STATUS, (Object)response.getStatus()).addLabels(HTTP_LABELS);
        } else {
            HttpRequestBindingData request = (HttpRequestBindingData)source;
            if (request.getRequestInfo() != null) {
                context.setProperty("http_request_info", (Object)request.getRequestInfo()).addLabels(HTTP_LABELS);
            }
        }
        for (Map.Entry<String, List<String>> entry : source.getHeaders().entrySet()) {
            String name = entry.getKey();
            if (!this.matches(name)) continue;
            List<String> values = entry.getValue();
            if (values != null && values.size() == 1) {
                context.setProperty(name, (Object)values.get(0)).addLabels(HTTP_LABELS);
                continue;
            }
            if (values == null || values.size() <= 1) continue;
            context.setProperty(name, values).addLabels(HTTP_LABELS);
        }
    }

    public void mapTo(Context context, HttpBindingData target) throws Exception {
        Map<String, List<String>> httpHeaders = target.getHeaders();
        for (Property property : context.getProperties()) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null || !this.matches(name) && !property.hasLabel(EndpointLabel.HTTP.label())) continue;
            if (HTTP_RESPONSE_STATUS.equalsIgnoreCase(name) && target instanceof HttpResponseBindingData) {
                HttpResponseBindingData response = (HttpResponseBindingData)target;
                if (value instanceof String) {
                    response.setStatus(Integer.parseInt((String)value));
                    continue;
                }
                if (!(value instanceof Integer)) continue;
                response.setStatus((Integer)value);
                continue;
            }
            if (value instanceof List) {
                ArrayList<String> vals = new ArrayList<String>();
                List valueList = (List)value;
                for (Object obj : valueList) {
                    if (obj instanceof String) {
                        vals.add((String)obj);
                        continue;
                    }
                    vals.add(obj.toString());
                }
                httpHeaders.put(name, vals);
                continue;
            }
            if (!(value instanceof String)) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add(String.valueOf(value));
            httpHeaders.put(name, list);
        }
    }
}

