/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import javax.jms.BytesMessage;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.component.common.composer.BaseMessageComposer;
import org.switchyard.exception.SwitchYardException;

public class JMSMessageComposer
extends BaseMessageComposer<javax.jms.Message> {
    public Message compose(javax.jms.Message source, Exchange exchange, boolean create) throws Exception {
        BytesMessage sourceBytes = (BytesMessage)source;
        if (sourceBytes.getBodyLength() > Integer.MAX_VALUE) {
            throw new SwitchYardException("The size of message content exceeds 2147483647 bytes, that is not supported by this MessageComposer");
        }
        byte[] bytearr = new byte[(int)sourceBytes.getBodyLength()];
        sourceBytes.readBytes(bytearr);
        Message message = create ? exchange.createMessage() : exchange.getMessage();
        this.getContextMapper().mapFrom((Object)source, exchange.getContext());
        message.setContent((Object)new String(bytearr));
        return message;
    }

    public javax.jms.Message decompose(Exchange exchange, javax.jms.Message target) throws Exception {
        BytesMessage targetBytes = (BytesMessage)target;
        this.getContextMapper().mapTo(exchange.getContext(), (Object)target);
        byte[] content = ((String)exchange.getMessage().getContent(String.class)).getBytes();
        targetBytes.writeBytes(content);
        return target;
    }
}

