/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.deploy;

import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.jboss.as.connector.ConnectorServices;
import org.jboss.jca.core.spi.rar.Activation;
import org.jboss.jca.core.spi.rar.MessageListener;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.switchyard.component.jca.config.model.JCABindingModel;
import org.switchyard.component.jca.deploy.InboundHandler;
import org.switchyard.component.jca.deploy.JCAInflowDeploymentMetaData;
import org.switchyard.component.jca.deploy.OutboundHandler;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.component.jca.processor.AbstractOutboundProcessor;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;

public class JCAActivator
extends BaseActivator {
    private static final String JBOSS_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    private static final String[] TYPES = new String[]{"jca"};
    private final ClassLoader _appClassLoader = Thread.currentThread().getContextClassLoader();
    private TransactionManager _transactionManager;
    private ResourceAdapterRepository _raRepository;

    public JCAActivator() {
        super(TYPES);
    }

    public ServiceHandler activateBinding(QName name, BindingModel config) {
        if (this._raRepository == null) {
            throw new IllegalStateException("ResourceAdapterRepository must be injected to activate JCA component.");
        }
        if (this._transactionManager == null) {
            try {
                this._transactionManager = (TransactionManager)new InitialContext().lookup(JBOSS_TRANSACTION_MANAGER);
            }
            catch (NamingException e) {
                throw new IllegalArgumentException("Unable to find TransactionManager in JNDI at java:jboss/TransactionManager", e);
            }
        }
        if (config.isServiceBinding()) {
            return this.handleServiceBinding((JCABindingModel)config, name);
        }
        return this.handleReferenceBinding((JCABindingModel)config, name);
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void setResourceAdapterRepository(ResourceAdapterRepository repository) {
        this._raRepository = repository;
    }

    private InboundHandler handleServiceBinding(JCABindingModel config, QName name) {
        JCABindingModel jcaconfig = config;
        String raName = jcaconfig.getInboundConnection().getResourceAdapter().getName();
        String raid = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)this.stripDotRarSuffix(raName));
        if (raid == null) {
            throw new IllegalArgumentException("Unique key for ResourceAdapter '" + raName + "' couldn't be found.");
        }
        Properties raProps = jcaconfig.getInboundConnection().getResourceAdapter().getProperties();
        Properties activationProps = jcaconfig.getInboundConnection().getActivationSpec().getProperties();
        String listener = jcaconfig.getInboundInteraction().getListener().getClassName();
        String operationName = jcaconfig.getInboundInteraction().getInboundOperation().getName();
        String endpointClassName = jcaconfig.getInboundInteraction().getEndpoint().getEndpointClassName();
        Properties endpointProps = jcaconfig.getInboundInteraction().getEndpoint().getProperties();
        Class<?> listenerType = null;
        try {
            listenerType = this._appClassLoader.loadClass(listener != null ? listener : "javax.resource.cci.MessageListener");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        ActivationSpec activationSpec = null;
        ResourceAdapter resourceAdapter = null;
        MessageListener listenerContainer = null;
        try {
            List listeners = this._raRepository.getMessageListeners(raid);
            for (MessageListener l : listeners) {
                if (!listenerType.equals(l.getType())) continue;
                listenerContainer = l;
            }
            if (listenerContainer == null) {
                throw new IllegalArgumentException("listener type " + listenerType.getName() + " is not supported by ResourceAdapter " + raName);
            }
            Activation activation = listenerContainer.getActivation();
            activationSpec = activation.createInstance();
            if (!activationProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)activationSpec, (Properties)activationProps);
            }
            resourceAdapter = this._raRepository.getResourceAdapter(raid);
            if (!raProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)resourceAdapter, (Properties)raProps);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't acquire the ResourceAdapter '" + raName + "'.", e);
        }
        AbstractInflowEndpoint endpoint = null;
        Class<?> endpointClass = null;
        try {
            endpointClass = this._appClassLoader.loadClass(endpointClassName);
            endpoint = (AbstractInflowEndpoint)endpointClass.newInstance();
            if (!endpointProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)endpoint, (Properties)endpointProps);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Endpoint class '" + endpointClassName + "' couldn't be instantiated.", e);
        }
        boolean transacted = jcaconfig.getInboundInteraction().isTransacted();
        endpoint.setApplicationClassLoader(this._appClassLoader).setOperationName(operationName).setServiceDomain(this.getServiceDomain()).setServiceQName(name).setDeliveryTransacted(transacted).setJCABindingModel(jcaconfig);
        JCAInflowDeploymentMetaData inflowMetaData = new JCAInflowDeploymentMetaData().setActivationSpec(activationSpec).setApplicationClassLoader(this._appClassLoader).setListenerInterface(listenerType).setMessageEndpoint(endpoint).setResourceAdapter(resourceAdapter).setTransactionManager(this._transactionManager).setDeliveryTransacted(transacted);
        return new InboundHandler(inflowMetaData);
    }

    private OutboundHandler handleReferenceBinding(JCABindingModel config, QName name) {
        JCABindingModel jcaconfig = config;
        boolean managed = jcaconfig.getOutboundConnection().isManaged();
        if (!managed) {
            throw new IllegalArgumentException("Non-Managed Scenario is not supported yet");
        }
        Properties raProps = jcaconfig.getOutboundConnection().getResourceAdapter().getProperties();
        String raName = jcaconfig.getOutboundConnection().getResourceAdapter().getName();
        String raid = ConnectorServices.getRegisteredResourceAdapterIdentifier((String)this.stripDotRarSuffix(raName));
        if (raid == null) {
            throw new IllegalArgumentException("Unique key for ResourceAdapter '" + raName + "' couldn't be found.");
        }
        ResourceAdapter resourceAdapter = null;
        try {
            resourceAdapter = this._raRepository.getResourceAdapter(raid);
            if (!raProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)resourceAdapter, (Properties)raProps);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't acquire the ResourceAdapter '" + raName + "'.", e);
        }
        Properties processorProps = jcaconfig.getOutboundInteraction().getProcessor().getProperties();
        AbstractOutboundProcessor processor = null;
        String processorClassName = jcaconfig.getOutboundInteraction().getProcessor().getProcessorClassName();
        Class<?> processorClass = null;
        try {
            processorClass = this._appClassLoader.loadClass(processorClassName);
            processor = (AbstractOutboundProcessor)processorClass.newInstance();
            if (!processorProps.isEmpty()) {
                PropertyEditors.mapJavaBeanProperties((Object)processor, (Properties)processorProps);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Outbound Processor class '" + processorClassName + "' couldn't be instantiated.", e);
        }
        String cfJndiName = jcaconfig.getOutboundConnection().getConnection().getConnectionFactoryJNDIName();
        Properties connProps = jcaconfig.getOutboundConnection().getConnection().getProperties();
        processor.setApplicationClassLoader(this._appClassLoader).setMCFProperties(connProps).setConnectionFactoryJNDIName(cfJndiName);
        if (jcaconfig.getOutboundInteraction().getConnectionSpec() != null) {
            String connSpecClassName = jcaconfig.getOutboundInteraction().getConnectionSpec().getConnectionSpecClassName();
            Properties connSpecProps = jcaconfig.getOutboundInteraction().getConnectionSpec().getProperties();
            processor.setConnectionSpec(connSpecClassName, connSpecProps);
        }
        if (jcaconfig.getOutboundInteraction().getInteractionSpec() != null) {
            String interactSpecClassName = jcaconfig.getOutboundInteraction().getInteractionSpec().getInteractionSpecClassName();
            Properties interactSpecProps = jcaconfig.getOutboundInteraction().getInteractionSpec().getProperties();
            processor.setInteractionSpec(interactSpecClassName, interactSpecProps);
        }
        return new OutboundHandler(processor);
    }

    private String stripDotRarSuffix(String raName) {
        if (raName == null) {
            return null;
        }
        if (raName.endsWith(".rar")) {
            return raName.substring(0, raName.indexOf(".rar"));
        }
        return raName;
    }
}

