/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.endpoint;

import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.composer.JCAComposition;
import org.switchyard.component.jca.config.model.JCABindingModel;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;

public abstract class AbstractInflowEndpoint {
    private JCABindingModel _jcaBindingModel;
    private ServiceDomain _domain;
    private QName _serviceQName;
    private ServiceReference _serviceRef;
    private String _operationName;
    private boolean _transacted = false;
    private ClassLoader _appClassLoader;

    public void initialize() {
        this._serviceRef = this._domain.getServiceReference(this._serviceQName);
    }

    public void uninitialize() {
    }

    public AbstractInflowEndpoint setJCABindingModel(JCABindingModel model) {
        this._jcaBindingModel = model;
        return this;
    }

    public JCABindingModel getJCABindingModel() {
        return this._jcaBindingModel;
    }

    public AbstractInflowEndpoint setServiceDomain(ServiceDomain domain) {
        this._domain = domain;
        return this;
    }

    public ServiceDomain getServiceDomain() {
        return this._domain;
    }

    public AbstractInflowEndpoint setServiceQName(QName qname) {
        this._serviceQName = qname;
        return this;
    }

    public QName getServiceQName() {
        return this._serviceQName;
    }

    public AbstractInflowEndpoint setServiceReference(ServiceReference ref) {
        this._serviceRef = ref;
        return this;
    }

    public ServiceReference getServiceReference() {
        return this._serviceRef;
    }

    public AbstractInflowEndpoint setOperationName(String name) {
        this._operationName = name;
        return this;
    }

    public String getOperationName() {
        return this._operationName;
    }

    public boolean isDeliveryTransacted() {
        return this._transacted;
    }

    public AbstractInflowEndpoint setDeliveryTransacted(boolean transacted) {
        this._transacted = transacted;
        return this;
    }

    public AbstractInflowEndpoint setApplicationClassLoader(ClassLoader loader) {
        this._appClassLoader = loader;
        return this;
    }

    public ClassLoader getApplicationClassLoader() {
        return this._appClassLoader;
    }

    protected Exchange createExchange(ExchangeHandler handler) {
        if (this._serviceRef == null) {
            throw new IllegalStateException("initialize() must be called before exchange.");
        }
        Exchange exchange = this._serviceRef.createExchange(this._operationName, handler);
        if (this._transacted) {
            PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        } else {
            PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        }
        return exchange;
    }

    protected Exchange createExchange() {
        return this.createExchange(null);
    }

    protected <T> MessageComposer<T> getMessageComposer(Class<T> clazz) {
        return JCAComposition.getMessageComposer(clazz);
    }
}

