/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.processor.cci;

import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import org.switchyard.component.jca.processor.cci.IndexedRecordHandler;
import org.switchyard.component.jca.processor.cci.MappedRecordHandler;
import org.switchyard.component.jca.processor.cci.RecordHandler;
import org.switchyard.exception.SwitchYardException;

public final class RecordHandlerFactory {
    private RecordHandlerFactory() {
    }

    public static RecordHandler<? extends Record> createRecordHandler(Class<?> recordType, ClassLoader loader) {
        if (recordType.equals(MappedRecord.class)) {
            return new MappedRecordHandler();
        }
        if (recordType.equals(IndexedRecord.class)) {
            return new IndexedRecordHandler();
        }
        try {
            Class<?> clazz = loader.loadClass(RecordHandlerFactory.class.getPackage().getName() + "." + recordType.getSimpleName() + "RecordHandler");
            return (RecordHandler)clazz.newInstance();
        }
        catch (Exception e) {
            throw new SwitchYardException("record type '" + recordType.getName() + "is not supported");
        }
    }
}

