/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.endpoint;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.MessageListener;
import javax.resource.cci.Record;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.exception.SwitchYardException;

public class CCIEndpoint
extends AbstractInflowEndpoint
implements MessageListener {
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final String DEFAULT_RECORD_NAME = "DefaultMappedRecord";
    private static final String DEFAULT_DESCRIPTION = "Default MappedRecord implementation by " + CCIEndpoint.class.getName();
    private long _waitTimeout = 15000L;
    private String _recordName = "DefaultMappedRecord";
    private String _description = DEFAULT_DESCRIPTION;
    private MessageComposer<MappedRecord> _composer;

    public Record onMessage(Record record) {
        if (this._composer == null) {
            this._composer = this.getMessageComposer(MappedRecord.class);
        }
        SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
        Exchange exchange = this.createExchange((ExchangeHandler)inOutHandler);
        try {
            exchange.send(this._composer.compose((Object)((MappedRecord)record), exchange, true));
            exchange = inOutHandler.waitForOut(this._waitTimeout);
            DefaultMappedRecord returnRecord = new DefaultMappedRecord();
            returnRecord.setRecordName(this._recordName);
            returnRecord.setRecordShortDescription(this._description);
            return (Record)this._composer.decompose(exchange, (Object)returnRecord);
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    private class DefaultMappedRecord
    implements MappedRecord {
        private static final long serialVersionUID = 6036209388088632116L;
        private String _recordName;
        private String _description;
        private HashMap<Object, Object> _map = new HashMap();

        private DefaultMappedRecord() {
        }

        public String getRecordName() {
            return this._recordName;
        }

        public void setRecordName(String name) {
            this._recordName = name;
        }

        public void setRecordShortDescription(String description) {
            this._description = description;
        }

        public String getRecordShortDescription() {
            return this._description;
        }

        public int size() {
            return this._map.size();
        }

        public boolean isEmpty() {
            return this._map.size() == 0;
        }

        public boolean containsKey(Object key) {
            return this._map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this._map.containsValue(value);
        }

        public Object get(Object key) {
            return this._map.get(key);
        }

        public Object put(Object key, Object value) {
            return this._map.put(key, value);
        }

        public Object remove(Object key) {
            return this._map.remove(key);
        }

        public void putAll(Map m) {
            this._map.putAll(m);
        }

        public void clear() {
            this._map.clear();
        }

        public Set keySet() {
            return this._map.keySet();
        }

        public Collection values() {
            return this._map.values();
        }

        public Set entrySet() {
            return this._map.entrySet();
        }

        public Object clone() {
            DefaultMappedRecord cloned = new DefaultMappedRecord();
            cloned.setRecordName(this.getRecordName().toString());
            cloned.setRecordShortDescription(this.getRecordShortDescription().toString());
            cloned.putAll((HashMap)this._map.clone());
            return cloned;
        }
    }
}

