/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import javax.resource.cci.IndexedRecord;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseContextMapper;

public class CCIIndexedRecordContextMapper
extends BaseContextMapper<IndexedRecord> {
    public void mapFrom(IndexedRecord source, Context context) throws Exception {
        String recordDescription;
        String recordName = source.getRecordName();
        if (recordName != null) {
            context.setProperty("recordName", (Object)recordName, Scope.EXCHANGE).addLabels(new String[]{"jca_message_property"});
        }
        if ((recordDescription = source.getRecordShortDescription()) != null) {
            context.setProperty("recordShortDescription", (Object)recordDescription, Scope.EXCHANGE).addLabels(new String[]{"jca_message_property"});
        }
    }

    public void mapTo(Context context, IndexedRecord target) throws Exception {
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null) continue;
            if (name.equals("recordName")) {
                target.setRecordName(value.toString());
                continue;
            }
            if (name.equals("recordShortDescription")) {
                target.setRecordShortDescription(value.toString());
                continue;
            }
            if (!this.matches(name)) continue;
            target.add((Object)(name + "=" + value));
        }
    }
}

