/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.composer;

import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Message;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.common.composer.BaseContextMapper;

public class JMSContextMapper
extends BaseContextMapper<Message> {
    public void mapFrom(Message source, Context context) throws Exception {
        Enumeration e = source.getPropertyNames();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (!this.matches(key)) continue;
            String value = null;
            try {
                value = source.getStringProperty(key);
            }
            catch (JMSException pce) {
                pce.getMessage();
            }
            if (value == null) continue;
            context.setProperty(key, (Object)value, Scope.EXCHANGE).addLabels(new String[]{"jca_message_property"});
        }
    }

    public void mapTo(Context context, Message target) throws Exception {
        for (Property property : context.getProperties(Scope.EXCHANGE)) {
            Object value;
            String name = property.getName();
            if (!this.matches(name) || (value = property.getValue()) == null) continue;
            try {
                target.setObjectProperty(name, value);
            }
            catch (JMSException pce) {
                pce.getMessage();
            }
        }
    }
}

