/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.jca.endpoint;

import javax.naming.InitialContext;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.MessageListener;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.component.jca.endpoint.AbstractInflowEndpoint;
import org.switchyard.exception.SwitchYardException;

public class CCIEndpoint
extends AbstractInflowEndpoint
implements MessageListener {
    private static final long DEFAULT_TIMEOUT = 15000L;
    private static final String DEFAULT_RECORD_NAME = "DefaultMappedRecord";
    private static final String DEFAULT_DESCRIPTION = "Default MappedRecord implementation by " + CCIEndpoint.class.getName();
    private String _connectionFactoryJNDIName;
    private long _waitTimeout = 15000L;
    private String _recordName = "DefaultMappedRecord";
    private String _description = DEFAULT_DESCRIPTION;
    private MessageComposer<MappedRecord> _composer;
    private RecordFactory _recordFactory;

    @Override
    public void initialize() {
        super.initialize();
        this._composer = this.getMessageComposer(MappedRecord.class);
        try {
            ConnectionFactory factory = (ConnectionFactory)new InitialContext().lookup(this._connectionFactoryJNDIName);
            this._recordFactory = factory.getRecordFactory();
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public Record onMessage(Record record) {
        SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
        Exchange exchange = this.createExchange((ExchangeHandler)inOutHandler);
        try {
            exchange.send(this._composer.compose((Object)((MappedRecord)record), exchange, true));
            exchange = inOutHandler.waitForOut(this._waitTimeout);
            MappedRecord returnRecord = this._recordFactory.createMappedRecord(this._recordName);
            returnRecord.setRecordShortDescription(this._description);
            return (Record)this._composer.decompose(exchange, (Object)returnRecord);
        }
        catch (Exception e) {
            throw new SwitchYardException((Throwable)e);
        }
    }

    public void setConnectionFactoryJNDIName(String name) {
        this._connectionFactoryJNDIName = name;
    }

    public String getConnectionFactoryJNDIName() {
        return this._connectionFactoryJNDIName;
    }
}

